/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.websocket.client.io;

import com.signalfx.shaded.jetty.io.ByteBufferPool;
import com.signalfx.shaded.jetty.io.Connection;
import com.signalfx.shaded.jetty.io.EndPoint;
import com.signalfx.shaded.jetty.io.SelectChannelEndPoint;
import com.signalfx.shaded.jetty.io.SelectorManager;
import com.signalfx.shaded.jetty.io.ssl.SslConnection;
import com.signalfx.shaded.jetty.util.log.Log;
import com.signalfx.shaded.jetty.util.log.Logger;
import com.signalfx.shaded.jetty.util.ssl.SslContextFactory;
import com.signalfx.shaded.jetty.websocket.api.WebSocketPolicy;
import com.signalfx.shaded.jetty.websocket.client.WebSocketClient;
import com.signalfx.shaded.jetty.websocket.client.io.ConnectPromise;
import com.signalfx.shaded.jetty.websocket.client.io.UpgradeConnection;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;

public class WebSocketClientSelectorManager
extends SelectorManager {
    private static final Logger LOG = Log.getLogger(WebSocketClientSelectorManager.class);
    private final WebSocketPolicy policy;
    private final ByteBufferPool bufferPool;
    private SslContextFactory sslContextFactory;

    public WebSocketClientSelectorManager(WebSocketClient client) {
        super(client.getExecutor(), client.getScheduler());
        this.bufferPool = client.getBufferPool();
        this.policy = client.getPolicy();
    }

    @Override
    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection Failed", ex);
        }
        ConnectPromise connect = (ConnectPromise)attachment;
        connect.failed(ex);
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    public Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("newConnection({},{},{})", channel, endPoint, attachment);
        }
        ConnectPromise connectPromise = (ConnectPromise)attachment;
        try {
            String scheme = connectPromise.getRequest().getRequestURI().getScheme();
            if ("wss".equalsIgnoreCase(scheme)) {
                SslContextFactory sslContextFactory = this.getSslContextFactory();
                if (sslContextFactory != null) {
                    SSLEngine engine = this.newSSLEngine(sslContextFactory, channel);
                    SslConnection sslConnection = new SslConnection(this.bufferPool, this.getExecutor(), endPoint, engine, true, true);
                    sslConnection.setRenegotiationAllowed(sslContextFactory.isRenegotiationAllowed());
                    SslConnection.DecryptedEndPoint sslEndPoint = sslConnection.getDecryptedEndPoint();
                    UpgradeConnection connection = this.newUpgradeConnection(channel, sslEndPoint, connectPromise);
                    sslEndPoint.setIdleTimeout(connectPromise.getClient().getMaxIdleTimeout());
                    sslEndPoint.setConnection(connection);
                    return sslConnection;
                }
                throw new IOException("Cannot init SSL");
            }
            endPoint.setIdleTimeout(connectPromise.getDriver().getPolicy().getIdleTimeout());
            return this.newUpgradeConnection(channel, endPoint, connectPromise);
        }
        catch (IOException e) {
            LOG.ignore(e);
            connectPromise.failed(e);
            throw e;
        }
    }

    @Override
    protected EndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selectSet, SelectionKey selectionKey) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("newEndPoint({}, {}, {})", channel, selectSet, selectionKey);
        }
        return new SelectChannelEndPoint(channel, selectSet, selectionKey, this.getScheduler(), this.policy.getIdleTimeout());
    }

    public SSLEngine newSSLEngine(SslContextFactory sslContextFactory, SocketChannel channel) {
        String peerHost = channel.socket().getInetAddress().getHostName();
        int peerPort = channel.socket().getPort();
        SSLEngine engine = sslContextFactory.newSSLEngine(peerHost, peerPort);
        engine.setUseClientMode(true);
        return engine;
    }

    public UpgradeConnection newUpgradeConnection(SocketChannel channel, EndPoint endPoint, ConnectPromise connectPromise) {
        WebSocketClient client = connectPromise.getClient();
        Executor executor = client.getExecutor();
        UpgradeConnection connection = new UpgradeConnection(endPoint, executor, connectPromise);
        return connection;
    }

    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }
}

