/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.util;

import com.signalfx.shaded.jetty.util.resource.Resource;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Loader {
    public static URL getResource(Class<?> loadClass, String name) {
        ClassLoader load_loader;
        URL url = null;
        ClassLoader context_loader = Thread.currentThread().getContextClassLoader();
        if (context_loader != null) {
            url = context_loader.getResource(name);
        }
        if (url == null && loadClass != null && (load_loader = loadClass.getClassLoader()) != null && load_loader != context_loader) {
            url = load_loader.getResource(name);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(name);
        }
        return url;
    }

    public static Class loadClass(Class loadClass, String name) throws ClassNotFoundException {
        Class<?> c;
        ClassNotFoundException ex;
        block10: {
            ClassLoader load_loader;
            ex = null;
            c = null;
            ClassLoader context_loader = Thread.currentThread().getContextClassLoader();
            if (context_loader != null) {
                try {
                    c = context_loader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                }
            }
            if (c == null && loadClass != null && (load_loader = loadClass.getClassLoader()) != null && load_loader != context_loader) {
                try {
                    c = load_loader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (ex != null) break block10;
                    ex = e;
                }
            }
        }
        if (c == null) {
            try {
                c = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                if (ex != null) {
                    throw ex;
                }
                throw e;
            }
        }
        return c;
    }

    public static ResourceBundle getResourceBundle(Class<?> loadClass, String name, boolean checkParents, Locale locale) throws MissingResourceException {
        ResourceBundle bundle;
        MissingResourceException ex;
        block12: {
            ex = null;
            bundle = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            while (bundle == null && loader != null) {
                block10: {
                    try {
                        bundle = ResourceBundle.getBundle(name, locale, loader);
                    }
                    catch (MissingResourceException e) {
                        if (ex != null) break block10;
                        ex = e;
                    }
                }
                loader = bundle == null && checkParents ? loader.getParent() : null;
            }
            ClassLoader classLoader = loader = loadClass == null ? null : loadClass.getClassLoader();
            while (bundle == null && loader != null) {
                block11: {
                    try {
                        bundle = ResourceBundle.getBundle(name, locale, loader);
                    }
                    catch (MissingResourceException e) {
                        if (ex != null) break block11;
                        ex = e;
                    }
                }
                loader = bundle == null && checkParents ? loader.getParent() : null;
            }
            if (bundle == null) {
                try {
                    bundle = ResourceBundle.getBundle(name, locale);
                }
                catch (MissingResourceException e) {
                    if (ex != null) break block12;
                    ex = e;
                }
            }
        }
        if (bundle != null) {
            return bundle;
        }
        throw ex;
    }

    public static String getClassPath(ClassLoader loader) throws Exception {
        StringBuilder classpath = new StringBuilder();
        while (loader != null && loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    Resource resource = Resource.newResource(urls[i]);
                    File file = resource.getFile();
                    if (file == null || !file.exists()) continue;
                    if (classpath.length() > 0) {
                        classpath.append(File.pathSeparatorChar);
                    }
                    classpath.append(file.getAbsolutePath());
                }
            }
            loader = loader.getParent();
        }
        return classpath.toString();
    }
}

