/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.io;

import com.signalfx.shaded.jetty.io.Connection;
import com.signalfx.shaded.jetty.io.EndPoint;
import com.signalfx.shaded.jetty.util.log.Log;
import com.signalfx.shaded.jetty.util.log.Logger;
import java.io.IOException;
import java.util.Map;

public interface ClientConnectionFactory {
    public Connection newConnection(EndPoint var1, Map<String, Object> var2) throws IOException;

    public static class Helper {
        private static Logger LOG = Log.getLogger(Helper.class);

        private Helper() {
        }

        public static void replaceConnection(Connection oldConnection, Connection newConnection) {
            Helper.close(oldConnection);
            oldConnection.getEndPoint().setConnection(newConnection);
            Helper.open(newConnection);
        }

        private static void open(Connection connection) {
            try {
                connection.onOpen();
            }
            catch (Throwable x) {
                LOG.debug(x);
            }
        }

        private static void close(Connection connection) {
            try {
                connection.onClose();
            }
            catch (Throwable x) {
                LOG.debug(x);
            }
        }
    }
}

