/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.google.common.graph;

import com.signalfx.shaded.google.common.annotations.Beta;
import com.signalfx.shaded.google.common.base.Function;
import com.signalfx.shaded.google.common.base.Functions;
import com.signalfx.shaded.google.common.base.Preconditions;
import com.signalfx.shaded.google.common.collect.ImmutableMap;
import com.signalfx.shaded.google.common.collect.Maps;
import com.signalfx.shaded.google.common.graph.AbstractGraphBuilder;
import com.signalfx.shaded.google.common.graph.ConfigurableValueGraph;
import com.signalfx.shaded.google.common.graph.DirectedGraphConnections;
import com.signalfx.shaded.google.common.graph.ForwardingGraph;
import com.signalfx.shaded.google.common.graph.Graph;
import com.signalfx.shaded.google.common.graph.GraphBuilder;
import com.signalfx.shaded.google.common.graph.GraphConnections;
import com.signalfx.shaded.google.common.graph.GraphConstants;
import com.signalfx.shaded.google.common.graph.UndirectedGraphConnections;
import com.signalfx.shaded.google.common.graph.ValueGraph;

@Beta
public abstract class ImmutableGraph<N>
extends ForwardingGraph<N> {
    ImmutableGraph() {
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ValueBackedImpl<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size());
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors(node), Maps.asMap(graph.successors(node), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    static class ValueBackedImpl<N, V>
    extends ImmutableGraph<N> {
        protected final ValueGraph<N, V> backingValueGraph;

        ValueBackedImpl(AbstractGraphBuilder<? super N> builder, ImmutableMap<N, GraphConnections<N, V>> nodeConnections, long edgeCount) {
            this.backingValueGraph = new ConfigurableValueGraph<N, V>(builder, nodeConnections, edgeCount);
        }

        @Override
        protected Graph<N> delegate() {
            return this.backingValueGraph;
        }
    }
}

