/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.connection;

import com.signalfx.metrics.SignalFxMetricsException;
import com.signalfx.metrics.connection.DataPointReceiver;
import com.signalfx.metrics.protobuf.SignalFxProtocolBuffers;
import com.signalfx.shaded.apache.commons.lang3.tuple.Pair;
import com.signalfx.shaded.google.common.collect.Lists;
import com.signalfx.shaded.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StoredDataPointReceiver
implements DataPointReceiver {
    public final List<SignalFxProtocolBuffers.DataPointOrBuilder> addDataPoints = Collections.synchronizedList(new ArrayList());
    private final Map<Pair<String, String>, List<SignalFxProtocolBuffers.Datum>> pointsFor;
    public final Map<String, SignalFxProtocolBuffers.MetricType> registeredMetrics = Collections.synchronizedMap(new HashMap());
    public boolean throwOnAdd = false;

    public StoredDataPointReceiver() {
        this.pointsFor = Maps.newHashMap();
    }

    @Override
    public void addDataPoints(String auth, List<SignalFxProtocolBuffers.DataPoint> dataPoints) throws SignalFxMetricsException {
        if (this.throwOnAdd) {
            throw new SignalFxMetricsException("Flag set to true");
        }
        this.addDataPoints.addAll(dataPoints);
        for (SignalFxProtocolBuffers.DataPoint dp : dataPoints) {
            Pair<String, String> key;
            String source = dp.getSource();
            if ("".equals(source)) {
                source = this.findSfSourceDim(dp.getDimensionsList());
            }
            if (this.pointsFor.containsKey(key = Pair.of(source, dp.getMetric()))) {
                this.pointsFor.get(key).add(dp.getValue());
                continue;
            }
            this.pointsFor.put(key, Lists.newArrayList(dp.getValue()));
        }
    }

    private String findSfSourceDim(List<SignalFxProtocolBuffers.Dimension> dimensionsList) {
        for (SignalFxProtocolBuffers.Dimension dim : dimensionsList) {
            if (!"sf_source".equals(dim.getKey())) continue;
            return dim.getValue();
        }
        return "";
    }

    @Override
    public void backfillDataPoints(String auth, String metric, String metricType, String orgId, Map<String, String> dimensions, List<SignalFxProtocolBuffers.PointValue> datumPoints) throws SignalFxMetricsException {
    }

    @Override
    public Map<String, Boolean> registerMetrics(String auth, Map<String, SignalFxProtocolBuffers.MetricType> metricTypes) throws SignalFxMetricsException {
        this.registeredMetrics.putAll(metricTypes);
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        for (Map.Entry<String, SignalFxProtocolBuffers.MetricType> i : metricTypes.entrySet()) {
            ret.put(i.getKey(), true);
        }
        return ret;
    }

    public List<SignalFxProtocolBuffers.Datum> valuesFor(String source, String metric) {
        Pair<String, String> key = Pair.of(source, metric);
        List<SignalFxProtocolBuffers.Datum> ret = this.pointsFor.get(key);
        if (ret == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ret);
    }

    public SignalFxProtocolBuffers.Datum lastValueFor(String source, String metric) {
        List<SignalFxProtocolBuffers.Datum> vals = this.valuesFor(source, metric);
        if (vals.isEmpty()) {
            throw new RuntimeException("No value for source/metric");
        }
        return vals.get(vals.size() - 1);
    }

    public boolean clearValues(String source, String metric) {
        Pair<String, String> key = Pair.of(source, metric);
        return this.pointsFor.remove(key) != null;
    }
}

