/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.databind.deser.std;

import com.signalfx.shaded.fasterxml.jackson.databind.BeanDescription;
import com.signalfx.shaded.fasterxml.jackson.databind.DeserializationConfig;
import com.signalfx.shaded.fasterxml.jackson.databind.JavaType;
import com.signalfx.shaded.fasterxml.jackson.databind.JsonDeserializer;
import com.signalfx.shaded.fasterxml.jackson.databind.JsonMappingException;
import com.signalfx.shaded.fasterxml.jackson.databind.KeyDeserializer;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.signalfx.shaded.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.signalfx.shaded.fasterxml.jackson.databind.util.ClassUtil;
import com.signalfx.shaded.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 923268084968181479L;

    @Deprecated
    public static KeyDeserializer constructStringKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) {
        return StdKeyDeserializer.StringKD.forType(javaType.getRawClass());
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver, AnnotatedMethod annotatedMethod) {
        return new StdKeyDeserializer.EnumKD(enumResolver, annotatedMethod);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        return new StdKeyDeserializer.DelegatingKD(javaType.getRawClass(), jsonDeserializer);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) {
        Object t = deserializationConfig.introspect(javaType);
        Constructor<?> constructor = ((BeanDescription)t).findSingleArgConstructor(String.class);
        if (constructor != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(constructor);
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(constructor);
        }
        Method method = ((BeanDescription)t).findFactoryMethod(String.class);
        if (method != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method);
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(method);
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (clazz == String.class || clazz == Object.class) {
            return StdKeyDeserializer.StringKD.forType(clazz);
        }
        if (clazz == UUID.class) {
            return new StdKeyDeserializer.UuidKD();
        }
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        if (clazz == Integer.class) {
            return new StdKeyDeserializer.IntKD();
        }
        if (clazz == Long.class) {
            return new StdKeyDeserializer.LongKD();
        }
        if (clazz == Date.class) {
            return new StdKeyDeserializer.DateKD();
        }
        if (clazz == Calendar.class) {
            return new StdKeyDeserializer.CalendarKD();
        }
        if (clazz == Boolean.class) {
            return new StdKeyDeserializer.BoolKD();
        }
        if (clazz == Byte.class) {
            return new StdKeyDeserializer.ByteKD();
        }
        if (clazz == Character.class) {
            return new StdKeyDeserializer.CharKD();
        }
        if (clazz == Short.class) {
            return new StdKeyDeserializer.ShortKD();
        }
        if (clazz == Float.class) {
            return new StdKeyDeserializer.FloatKD();
        }
        if (clazz == Double.class) {
            return new StdKeyDeserializer.DoubleKD();
        }
        if (clazz == Locale.class) {
            return new StdKeyDeserializer.LocaleKD();
        }
        return null;
    }
}

