/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.signalflow;

import com.signalfx.shaded.fasterxml.jackson.annotation.JsonCreator;
import com.signalfx.shaded.fasterxml.jackson.annotation.JsonProperty;
import com.signalfx.shaded.fasterxml.jackson.annotation.JsonSubTypes;
import com.signalfx.shaded.fasterxml.jackson.annotation.JsonTypeInfo;
import com.signalfx.shaded.fasterxml.jackson.annotation.JsonTypeName;
import com.signalfx.shaded.fasterxml.jackson.databind.DeserializationFeature;
import com.signalfx.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.signalfx.signalflow.SignalFlowException;
import com.signalfx.signalflow.StreamMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelMessage {
    protected static final Logger log = LoggerFactory.getLogger(ChannelMessage.class);
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected String rawdata;
    protected Type channelMessageType;

    public Type getType() {
        return this.channelMessageType;
    }

    public String toString() {
        return this.rawdata;
    }

    public static ChannelMessage decodeStreamMessage(StreamMessage streamMessage) throws SignalFlowException {
        try {
            ChannelMessage message = null;
            switch (streamMessage.getKind()) {
                case CONTROL: {
                    message = mapper.readValue(streamMessage.getData(), ControlMessage.class);
                    break;
                }
                case INFORMATION: {
                    message = mapper.readValue(streamMessage.getData(), InfoMessage.class);
                    break;
                }
                case METADATA: {
                    message = mapper.readValue(streamMessage.getData(), MetadataMessage.class);
                    break;
                }
                case EXPIRED_TSID: {
                    message = mapper.readValue(streamMessage.getData(), ExpiredTsIdMessage.class);
                    break;
                }
                case DATA: {
                    message = mapper.readValue(streamMessage.getData(), DataMessage.class);
                    break;
                }
                case EVENT: {
                    message = mapper.readValue(streamMessage.getData(), EventMessage.class);
                    break;
                }
                case ERROR: {
                    message = mapper.readValue(streamMessage.getData(), ErrorMessage.class);
                }
            }
            if (log.isDebugEnabled()) {
                message.rawdata = streamMessage.getData();
            }
            return message;
        }
        catch (IOException ex) {
            log.error(streamMessage.toString(), ex);
            throw new SignalFlowException("failed to decode stream message: " + streamMessage, ex);
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static class ErrorMessage
    extends ChannelMessage {
        protected ArrayList<Object> errors;

        public ErrorMessage() {
            this.channelMessageType = Type.ERROR_MESSAGE;
        }

        public List<Object> getErrors() {
            return this.errors;
        }
    }

    public static class EventMessage
    extends ChannelMessage {
        protected LinkedHashMap<String, Object> metadata;
        protected LinkedHashMap<String, Object> properties;
        protected long timestampMs;
        protected String tsId;

        public EventMessage() {
            this.channelMessageType = Type.EVENT_MESSAGE;
        }

        public String getTsId() {
            return this.tsId;
        }

        public long getTimestampMs() {
            return this.timestampMs;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    public static class DataMessage
    extends ChannelMessage {
        protected Map<String, Number> data;
        protected long logicalTimestampMs;

        @JsonCreator
        public DataMessage(@JsonProperty(value="logicalTimestampMs") long logicalTimestampMs, @JsonProperty(value="data") List<Map<String, Object>> data) {
            this.channelMessageType = Type.DATA_MESSAGE;
            this.logicalTimestampMs = logicalTimestampMs;
            this.data = new HashMap<String, Number>(data.size());
            for (Map<String, Object> datum : data) {
                this.data.put((String)datum.get("tsId"), (Number)datum.get("value"));
            }
        }

        public long getLogicalTimestampMs() {
            return this.logicalTimestampMs;
        }

        public Map<String, Number> getData() {
            return this.data;
        }

        public void addData(Map<String, Number> data) {
            this.data.putAll(data);
        }
    }

    public static class ExpiredTsIdMessage
    extends ChannelMessage {
        protected String tsId;

        public ExpiredTsIdMessage() {
            this.channelMessageType = Type.EXPIRED_TSID_MESSAGE;
        }

        public String getTsId() {
            return this.tsId;
        }
    }

    public static class MetadataMessage
    extends ChannelMessage {
        protected LinkedHashMap<String, Object> properties;
        protected String tsId;

        public MetadataMessage() {
            this.channelMessageType = Type.METADATA_MESSAGE;
        }

        public String getTsId() {
            return this.tsId;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    public static class InfoMessage
    extends ChannelMessage {
        protected LinkedHashMap<String, Object> message;
        protected long logicalTimestampMs;

        public InfoMessage() {
            this.channelMessageType = Type.INFO_MESSAGE;
        }

        public long getLogicalTimestampMs() {
            return this.logicalTimestampMs;
        }

        public Map<String, Object> getMessage() {
            return this.message;
        }
    }

    @JsonTypeName(value="CHANNEL_ABORT")
    public static class ChannelAbortMessage
    extends ControlMessage {
        protected LinkedHashMap<String, String> abortInfo;

        public ChannelAbortMessage() {
            this.channelMessageType = Type.CHANNEL_ABORT;
        }

        public Map<String, String> getAbortInfo() {
            return this.abortInfo;
        }
    }

    @JsonTypeName(value="JOB_PROGRESS")
    public static class JobProgressMessage
    extends ControlMessage {
        protected int progress;

        public JobProgressMessage() {
            this.channelMessageType = Type.JOB_PROGRESS;
        }

        public int getProgress() {
            return this.progress;
        }
    }

    @JsonTypeName(value="JOB_START")
    public static class JobStartMessage
    extends ControlMessage {
        protected String handle;

        public JobStartMessage() {
            this.channelMessageType = Type.JOB_START;
        }

        public String getHandle() {
            return this.handle;
        }
    }

    @JsonTypeName(value="END_OF_CHANNEL")
    public static class EndOfChannelMessage
    extends ControlMessage {
        public EndOfChannelMessage() {
            this.channelMessageType = Type.END_OF_CHANNEL;
        }
    }

    @JsonTypeName(value="STREAM_START")
    public static class StreamStartMessage
    extends ControlMessage {
        public StreamStartMessage() {
            this.channelMessageType = Type.STREAM_START;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="event", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=StreamStartMessage.class, name="STREAM_START"), @JsonSubTypes.Type(value=JobStartMessage.class, name="JOB_START"), @JsonSubTypes.Type(value=JobProgressMessage.class, name="JOB_PROGRESS"), @JsonSubTypes.Type(value=ChannelAbortMessage.class, name="CHANNEL_ABORT"), @JsonSubTypes.Type(value=EndOfChannelMessage.class, name="END_OF_CHANNEL")})
    public static abstract class ControlMessage
    extends ChannelMessage {
        protected long timestampMs;

        public long getTimestampMs() {
            return this.timestampMs;
        }
    }

    public static enum Type {
        STREAM_START(StreamMessage.Kind.CONTROL),
        JOB_START(StreamMessage.Kind.CONTROL),
        JOB_PROGRESS(StreamMessage.Kind.CONTROL),
        CHANNEL_ABORT(StreamMessage.Kind.CONTROL),
        END_OF_CHANNEL(StreamMessage.Kind.CONTROL),
        INFO_MESSAGE(StreamMessage.Kind.INFORMATION),
        METADATA_MESSAGE(StreamMessage.Kind.METADATA),
        EXPIRED_TSID_MESSAGE(StreamMessage.Kind.EXPIRED_TSID),
        DATA_MESSAGE(StreamMessage.Kind.DATA),
        EVENT_MESSAGE(StreamMessage.Kind.EVENT),
        ERROR_MESSAGE(StreamMessage.Kind.ERROR);

        private final StreamMessage.Kind kind;

        private Type(StreamMessage.Kind kind) {
            this.kind = kind;
        }

        StreamMessage.Kind kind() {
            return this.kind;
        }
    }
}

