/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.websocket;

import com.signalfx.shaded.jetty.io.EndPoint;
import com.signalfx.shaded.jetty.websocket.WebSocket;
import com.signalfx.shaded.jetty.websocket.WebSocketBuffers;
import com.signalfx.shaded.jetty.websocket.WebSocketConnectionD06;
import com.signalfx.shaded.jetty.websocket.WebSocketFactory;
import com.signalfx.shaded.jetty.websocket.WebSocketServletConnection;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebSocketServletConnectionD06
extends WebSocketConnectionD06
implements WebSocketServletConnection {
    private final WebSocketFactory factory;

    public WebSocketServletConnectionD06(WebSocketFactory factory, WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol) throws IOException {
        super(websocket, endpoint, buffers, timestamp, maxIdleTime, protocol);
        this.factory = factory;
    }

    @Override
    public void handshake(HttpServletRequest request, HttpServletResponse response, String subprotocol) throws IOException {
        String key = request.getHeader("Sec-WebSocket-Key");
        response.setHeader("Upgrade", "WebSocket");
        response.addHeader("Connection", "Upgrade");
        response.addHeader("Sec-WebSocket-Accept", WebSocketServletConnectionD06.hashKey(key));
        if (subprotocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", subprotocol);
        }
        response.sendError(101);
        this.onFrameHandshake();
        this.onWebSocketOpen();
    }

    @Override
    public void onClose() {
        super.onClose();
        this.factory.removeConnection(this);
    }
}

