/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.util.statistic;

import com.signalfx.shaded.jetty.util.Atomics;
import java.util.concurrent.atomic.AtomicLong;

public class CounterStatistic {
    protected final AtomicLong _max = new AtomicLong();
    protected final AtomicLong _curr = new AtomicLong();
    protected final AtomicLong _total = new AtomicLong();

    public void reset() {
        this.reset(0L);
    }

    public void reset(long value) {
        this._max.set(value);
        this._curr.set(value);
        this._total.set(0L);
    }

    public void add(long delta) {
        long value = this._curr.addAndGet(delta);
        if (delta > 0L) {
            this._total.addAndGet(delta);
        }
        Atomics.updateMax(this._max, value);
    }

    public void subtract(long delta) {
        this.add(-delta);
    }

    public void increment() {
        this.add(1L);
    }

    public void decrement() {
        this.add(-1L);
    }

    public long getMax() {
        return this._max.get();
    }

    public long getCurrent() {
        return this._curr.get();
    }

    public long getTotal() {
        return this._total.get();
    }
}

