/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.databind.ser.std;

import com.signalfx.shaded.fasterxml.jackson.core.JsonGenerationException;
import com.signalfx.shaded.fasterxml.jackson.core.JsonGenerator;
import com.signalfx.shaded.fasterxml.jackson.databind.BeanProperty;
import com.signalfx.shaded.fasterxml.jackson.databind.JavaType;
import com.signalfx.shaded.fasterxml.jackson.databind.JsonMappingException;
import com.signalfx.shaded.fasterxml.jackson.databind.JsonNode;
import com.signalfx.shaded.fasterxml.jackson.databind.JsonSerializer;
import com.signalfx.shaded.fasterxml.jackson.databind.SerializationFeature;
import com.signalfx.shaded.fasterxml.jackson.databind.SerializerProvider;
import com.signalfx.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.signalfx.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.signalfx.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.signalfx.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.signalfx.shaded.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.signalfx.shaded.fasterxml.jackson.databind.node.ObjectNode;
import com.signalfx.shaded.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.signalfx.shaded.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.signalfx.shaded.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.signalfx.shaded.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;

public class StdArraySerializers {
    protected static final HashMap<String, JsonSerializer<?>> _arraySerializers = new HashMap();

    protected StdArraySerializers() {
    }

    public static JsonSerializer<?> findStandardImpl(Class<?> clazz) {
        return _arraySerializers.get(clazz.getName());
    }

    static {
        _arraySerializers.put(boolean[].class.getName(), new BooleanArraySerializer());
        _arraySerializers.put(byte[].class.getName(), new ByteArraySerializer());
        _arraySerializers.put(char[].class.getName(), new CharArraySerializer());
        _arraySerializers.put(short[].class.getName(), new ShortArraySerializer());
        _arraySerializers.put(int[].class.getName(), new IntArraySerializer());
        _arraySerializers.put(long[].class.getName(), new LongArraySerializer());
        _arraySerializers.put(float[].class.getName(), new FloatArraySerializer());
        _arraySerializers.put(double[].class.getName(), new DoubleArraySerializer());
    }

    @JacksonStdImpl
    public static final class DoubleArraySerializer
    extends ArraySerializerBase<double[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Double.TYPE);

        public DoubleArraySerializer() {
            super(double[].class, null);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(double[] dArray) {
            return dArray == null || dArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(double[] dArray) {
            return dArray.length == 1;
        }

        @Override
        public void serializeContents(double[] dArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeNumber(dArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            objectNode.put("items", this.createSchemaNode("number"));
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            JsonArrayFormatVisitor jsonArrayFormatVisitor;
            if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
                jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.NUMBER);
            }
        }
    }

    @JacksonStdImpl
    public static final class FloatArraySerializer
    extends TypedPrimitiveArraySerializer<float[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Float.TYPE);

        public FloatArraySerializer() {
            super(float[].class);
        }

        public FloatArraySerializer(FloatArraySerializer floatArraySerializer, BeanProperty beanProperty, TypeSerializer typeSerializer) {
            super(floatArraySerializer, beanProperty, typeSerializer);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return new FloatArraySerializer(this, this._property, typeSerializer);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(float[] fArray) {
            return fArray == null || fArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(float[] fArray) {
            return fArray.length == 1;
        }

        @Override
        public void serializeContents(float[] fArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            if (this._valueTypeSerializer != null) {
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    this._valueTypeSerializer.writeTypePrefixForScalar(null, jsonGenerator, Float.TYPE);
                    jsonGenerator.writeNumber(fArray[i]);
                    this._valueTypeSerializer.writeTypeSuffixForScalar(null, jsonGenerator);
                }
                return;
            }
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeNumber(fArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            objectNode.put("items", this.createSchemaNode("number"));
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            JsonArrayFormatVisitor jsonArrayFormatVisitor;
            if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
                jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.NUMBER);
            }
        }
    }

    @JacksonStdImpl
    public static final class LongArraySerializer
    extends TypedPrimitiveArraySerializer<long[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Long.TYPE);

        public LongArraySerializer() {
            super(long[].class);
        }

        public LongArraySerializer(LongArraySerializer longArraySerializer, BeanProperty beanProperty, TypeSerializer typeSerializer) {
            super(longArraySerializer, beanProperty, typeSerializer);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return new LongArraySerializer(this, this._property, typeSerializer);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(long[] lArray) {
            return lArray == null || lArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(long[] lArray) {
            return lArray.length == 1;
        }

        @Override
        public void serializeContents(long[] lArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            if (this._valueTypeSerializer != null) {
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    this._valueTypeSerializer.writeTypePrefixForScalar(null, jsonGenerator, Long.TYPE);
                    jsonGenerator.writeNumber(lArray[i]);
                    this._valueTypeSerializer.writeTypeSuffixForScalar(null, jsonGenerator);
                }
                return;
            }
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeNumber(lArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            objectNode.put("items", this.createSchemaNode("number", true));
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            JsonArrayFormatVisitor jsonArrayFormatVisitor;
            if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
                jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.NUMBER);
            }
        }
    }

    @JacksonStdImpl
    public static final class IntArraySerializer
    extends ArraySerializerBase<int[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Integer.TYPE);

        public IntArraySerializer() {
            super(int[].class, null);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(int[] nArray) {
            return nArray == null || nArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(int[] nArray) {
            return nArray.length == 1;
        }

        @Override
        public void serializeContents(int[] nArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeNumber(nArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            objectNode.put("items", this.createSchemaNode("integer"));
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            JsonArrayFormatVisitor jsonArrayFormatVisitor;
            if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
                jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.INTEGER);
            }
        }
    }

    @JacksonStdImpl
    public static final class CharArraySerializer
    extends StdSerializer<char[]> {
        public CharArraySerializer() {
            super(char[].class);
        }

        @Override
        public boolean isEmpty(char[] cArray) {
            return cArray == null || cArray.length == 0;
        }

        @Override
        public void serialize(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                jsonGenerator.writeStartArray();
                this._writeArrayContents(jsonGenerator, cArray);
                jsonGenerator.writeEndArray();
            } else {
                jsonGenerator.writeString(cArray, 0, cArray.length);
            }
        }

        @Override
        public void serializeWithType(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                typeSerializer.writeTypePrefixForArray(cArray, jsonGenerator);
                this._writeArrayContents(jsonGenerator, cArray);
                typeSerializer.writeTypeSuffixForArray(cArray, jsonGenerator);
            } else {
                typeSerializer.writeTypePrefixForScalar(cArray, jsonGenerator);
                jsonGenerator.writeString(cArray, 0, cArray.length);
                typeSerializer.writeTypeSuffixForScalar(cArray, jsonGenerator);
            }
        }

        private final void _writeArrayContents(JsonGenerator jsonGenerator, char[] cArray) throws IOException, JsonGenerationException {
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeString(cArray, i, 1);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            ObjectNode objectNode2 = this.createSchemaNode("string");
            objectNode2.put("type", "string");
            objectNode.put("items", objectNode2);
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            JsonArrayFormatVisitor jsonArrayFormatVisitor;
            if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
                jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.STRING);
            }
        }
    }

    @JacksonStdImpl
    public static final class ShortArraySerializer
    extends TypedPrimitiveArraySerializer<short[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Short.TYPE);

        public ShortArraySerializer() {
            super(short[].class);
        }

        public ShortArraySerializer(ShortArraySerializer shortArraySerializer, BeanProperty beanProperty, TypeSerializer typeSerializer) {
            super(shortArraySerializer, beanProperty, typeSerializer);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return new ShortArraySerializer(this, this._property, typeSerializer);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(short[] sArray) {
            return sArray == null || sArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(short[] sArray) {
            return sArray.length == 1;
        }

        @Override
        public void serializeContents(short[] sArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            if (this._valueTypeSerializer != null) {
                int n = sArray.length;
                for (int i = 0; i < n; ++i) {
                    this._valueTypeSerializer.writeTypePrefixForScalar(null, jsonGenerator, Short.TYPE);
                    jsonGenerator.writeNumber(sArray[i]);
                    this._valueTypeSerializer.writeTypeSuffixForScalar(null, jsonGenerator);
                }
                return;
            }
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeNumber((int)sArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            objectNode.put("items", this.createSchemaNode("integer"));
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            JsonArrayFormatVisitor jsonArrayFormatVisitor;
            if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
                jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.INTEGER);
            }
        }
    }

    @JacksonStdImpl
    public static final class ByteArraySerializer
    extends StdSerializer<byte[]> {
        public ByteArraySerializer() {
            super(byte[].class);
        }

        @Override
        public boolean isEmpty(byte[] byArray) {
            return byArray == null || byArray.length == 0;
        }

        @Override
        public void serialize(byte[] byArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeBinary(serializerProvider.getConfig().getBase64Variant(), byArray, 0, byArray.length);
        }

        @Override
        public void serializeWithType(byte[] byArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
            typeSerializer.writeTypePrefixForScalar(byArray, jsonGenerator);
            jsonGenerator.writeBinary(serializerProvider.getConfig().getBase64Variant(), byArray, 0, byArray.length);
            typeSerializer.writeTypeSuffixForScalar(byArray, jsonGenerator);
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            ObjectNode objectNode2 = this.createSchemaNode("string");
            objectNode.put("items", objectNode2);
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            JsonArrayFormatVisitor jsonArrayFormatVisitor;
            if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
                jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.STRING);
            }
        }
    }

    @JacksonStdImpl
    public static final class BooleanArraySerializer
    extends ArraySerializerBase<boolean[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Boolean.class);

        public BooleanArraySerializer() {
            super(boolean[].class, null);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(boolean[] blArray) {
            return blArray == null || blArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(boolean[] blArray) {
            return blArray.length == 1;
        }

        @Override
        public void serializeContents(boolean[] blArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeBoolean(blArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            objectNode.put("items", this.createSchemaNode("boolean"));
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            JsonArrayFormatVisitor jsonArrayFormatVisitor;
            if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
                jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.BOOLEAN);
            }
        }
    }

    protected static abstract class TypedPrimitiveArraySerializer<T>
    extends ArraySerializerBase<T> {
        protected final TypeSerializer _valueTypeSerializer;

        protected TypedPrimitiveArraySerializer(Class<T> clazz) {
            super(clazz);
            this._valueTypeSerializer = null;
        }

        protected TypedPrimitiveArraySerializer(TypedPrimitiveArraySerializer<T> typedPrimitiveArraySerializer, BeanProperty beanProperty, TypeSerializer typeSerializer) {
            super(typedPrimitiveArraySerializer, beanProperty);
            this._valueTypeSerializer = typeSerializer;
        }
    }
}

