/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.databind.deser;

import com.signalfx.shaded.fasterxml.jackson.core.JsonParser;
import com.signalfx.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.signalfx.shaded.fasterxml.jackson.core.JsonToken;
import com.signalfx.shaded.fasterxml.jackson.databind.BeanDescription;
import com.signalfx.shaded.fasterxml.jackson.databind.DeserializationContext;
import com.signalfx.shaded.fasterxml.jackson.databind.JsonDeserializer;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.impl.BeanAsArrayDeserializer;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.signalfx.shaded.fasterxml.jackson.databind.util.NameTransformer;
import com.signalfx.shaded.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;

public class BeanDeserializer
extends BeanDeserializerBase
implements Serializable {
    private static final long serialVersionUID = 1L;

    public BeanDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, BeanPropertyMap beanPropertyMap, Map<String, SettableBeanProperty> map, HashSet<String> hashSet, boolean bl, boolean bl2) {
        super(beanDeserializerBuilder, beanDescription, beanPropertyMap, map, hashSet, bl, bl2);
    }

    protected BeanDeserializer(BeanDeserializerBase beanDeserializerBase) {
        super(beanDeserializerBase, beanDeserializerBase._ignoreAllUnknown);
    }

    protected BeanDeserializer(BeanDeserializerBase beanDeserializerBase, boolean bl) {
        super(beanDeserializerBase, bl);
    }

    protected BeanDeserializer(BeanDeserializerBase beanDeserializerBase, NameTransformer nameTransformer) {
        super(beanDeserializerBase, nameTransformer);
    }

    public BeanDeserializer(BeanDeserializerBase beanDeserializerBase, ObjectIdReader objectIdReader) {
        super(beanDeserializerBase, objectIdReader);
    }

    public BeanDeserializer(BeanDeserializerBase beanDeserializerBase, HashSet<String> hashSet) {
        super(beanDeserializerBase, hashSet);
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        if (this.getClass() != BeanDeserializer.class) {
            return this;
        }
        return new BeanDeserializer((BeanDeserializerBase)this, nameTransformer);
    }

    @Override
    public BeanDeserializer withObjectIdReader(ObjectIdReader objectIdReader) {
        return new BeanDeserializer((BeanDeserializerBase)this, objectIdReader);
    }

    @Override
    public BeanDeserializer withIgnorableProperties(HashSet<String> hashSet) {
        return new BeanDeserializer((BeanDeserializerBase)this, hashSet);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        SettableBeanProperty[] settableBeanPropertyArray = this._beanProperties.getPropertiesInInsertionOrder();
        return new BeanAsArrayDeserializer((BeanDeserializerBase)this, settableBeanPropertyArray);
    }

    @Override
    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            if (this._vanillaProcessing) {
                return this.vanillaDeserialize(jsonParser, deserializationContext, jsonParser.nextToken());
            }
            jsonParser.nextToken();
            if (this._objectIdReader != null) {
                return this.deserializeWithObjectId(jsonParser, deserializationContext);
            }
            return this.deserializeFromObject(jsonParser, deserializationContext);
        }
        return this._deserializeOther(jsonParser, deserializationContext, jsonToken);
    }

    private final Object _deserializeOther(JsonParser jsonParser, DeserializationContext deserializationContext, JsonToken jsonToken) throws IOException, JsonProcessingException {
        if (jsonToken == null) {
            return this._missingToken(jsonParser, deserializationContext);
        }
        switch (jsonToken) {
            case VALUE_STRING: {
                return this.deserializeFromString(jsonParser, deserializationContext);
            }
            case VALUE_NUMBER_INT: {
                return this.deserializeFromNumber(jsonParser, deserializationContext);
            }
            case VALUE_NUMBER_FLOAT: {
                return this.deserializeFromDouble(jsonParser, deserializationContext);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return jsonParser.getEmbeddedObject();
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return this.deserializeFromBoolean(jsonParser, deserializationContext);
            }
            case START_ARRAY: {
                return this.deserializeFromArray(jsonParser, deserializationContext);
            }
            case FIELD_NAME: 
            case END_OBJECT: {
                if (this._vanillaProcessing) {
                    return this.vanillaDeserialize(jsonParser, deserializationContext, jsonToken);
                }
                if (this._objectIdReader != null) {
                    return this.deserializeWithObjectId(jsonParser, deserializationContext);
                }
                return this.deserializeFromObject(jsonParser, deserializationContext);
            }
        }
        throw deserializationContext.mappingException(this.getBeanClass());
    }

    protected Object _missingToken(JsonParser jsonParser, DeserializationContext deserializationContext) throws JsonProcessingException {
        throw deserializationContext.endOfInputException(this.getBeanClass());
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        Object object2;
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(jsonParser, deserializationContext, object);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, object);
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        if (this._needViewProcesing && (object2 = deserializationContext.getActiveView()) != null) {
            return this.deserializeWithView(jsonParser, deserializationContext, object, (Class<?>)object2);
        }
        while (jsonToken == JsonToken.FIELD_NAME) {
            object2 = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find((String)object2);
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, (String)object2, deserializationContext);
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(object2)) {
                jsonParser.skipChildren();
            } else if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, (String)object2);
            } else {
                this.handleUnknownProperty(jsonParser, deserializationContext, object, (String)object2);
            }
            jsonToken = jsonParser.nextToken();
        }
        return object;
    }

    private final Object vanillaDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, JsonToken jsonToken) throws IOException, JsonProcessingException {
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                }
            } else {
                this.handleUnknownVanilla(jsonParser, deserializationContext, object, string);
            }
            jsonParser.nextToken();
        }
        return object;
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object;
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(jsonParser, deserializationContext);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(jsonParser, deserializationContext);
            }
            return this.deserializeFromObjectUsingNonDefault(jsonParser, deserializationContext);
        }
        Object object2 = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object2);
        }
        if (this._needViewProcesing && (object = deserializationContext.getActiveView()) != null) {
            return this.deserializeWithView(jsonParser, deserializationContext, object2, (Class<?>)object);
        }
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            object = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find((String)object);
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object2);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object2, (String)object, deserializationContext);
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(object)) {
                jsonParser.skipChildren();
            } else if (this._anySetter != null) {
                try {
                    this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object2, (String)object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object2, (String)object, deserializationContext);
                }
            } else {
                this.handleUnknownProperty(jsonParser, deserializationContext, object2, (String)object);
            }
            jsonParser.nextToken();
        }
        return object2;
    }

    @Override
    protected Object _deserializeUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object;
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        TokenBuffer tokenBuffer = null;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            Object object2;
            object = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty((String)object);
            if (settableBeanProperty != null) {
                object2 = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                if (propertyValueBuffer.assignParameter(settableBeanProperty.getCreatorIndex(), object2)) {
                    Object object3;
                    jsonParser.nextToken();
                    try {
                        object3 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), (String)object, deserializationContext);
                        object3 = null;
                    }
                    if (object3.getClass() != this._beanType.getRawClass()) {
                        return this.handlePolymorphic(jsonParser, deserializationContext, object3, tokenBuffer);
                    }
                    if (tokenBuffer != null) {
                        object3 = this.handleUnknownProperties(deserializationContext, object3, tokenBuffer);
                    }
                    return this.deserialize(jsonParser, deserializationContext, object3);
                }
            } else if (!propertyValueBuffer.readIdProperty((String)object)) {
                object2 = this._beanProperties.find((String)object);
                if (object2 != null) {
                    propertyValueBuffer.bufferProperty((SettableBeanProperty)object2, ((SettableBeanProperty)object2).deserialize(jsonParser, deserializationContext));
                } else if (this._ignorableProps != null && this._ignorableProps.contains(object)) {
                    jsonParser.skipChildren();
                } else if (this._anySetter != null) {
                    propertyValueBuffer.bufferAnyProperty(this._anySetter, (String)object, this._anySetter.deserialize(jsonParser, deserializationContext));
                } else {
                    if (tokenBuffer == null) {
                        tokenBuffer = new TokenBuffer(jsonParser.getCodec());
                    }
                    tokenBuffer.writeFieldName((String)object);
                    tokenBuffer.copyCurrentStructure(jsonParser);
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            object = null;
        }
        if (tokenBuffer != null) {
            if (object.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, deserializationContext, object, tokenBuffer);
            }
            return this.handleUnknownProperties(deserializationContext, object, tokenBuffer);
        }
        return object;
    }

    protected final Object deserializeWithView(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, Class<?> clazz) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (!settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                jsonParser.skipChildren();
            } else if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
            } else {
                this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
            }
            jsonToken = jsonParser.nextToken();
        }
        return object;
    }

    protected Object deserializeWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Class<?> clazz;
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(jsonParser, deserializationContext);
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartObject();
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        Class<?> clazz2 = clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                jsonParser.skipChildren();
            } else {
                tokenBuffer.writeFieldName(string);
                tokenBuffer.copyCurrentStructure(jsonParser);
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            }
            jsonParser.nextToken();
        }
        tokenBuffer.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
        return object;
    }

    protected Object deserializeWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        Class<?> clazz;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartObject();
        Class<?> clazz2 = clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            jsonParser.nextToken();
            if (settableBeanProperty != null) {
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                jsonParser.skipChildren();
            } else {
                tokenBuffer.writeFieldName(string);
                tokenBuffer.copyCurrentStructure(jsonParser);
                if (this._anySetter != null) {
                    this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        tokenBuffer.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
        return object;
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object;
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartObject();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            block16: {
                Object object2;
                object = jsonParser.getCurrentName();
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty((String)object);
                if (settableBeanProperty != null) {
                    object2 = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                    if (propertyValueBuffer.assignParameter(settableBeanProperty.getCreatorIndex(), object2)) {
                        Object object3;
                        jsonToken = jsonParser.nextToken();
                        try {
                            object3 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                        }
                        catch (Exception exception) {
                            this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), (String)object, deserializationContext);
                            break block16;
                        }
                        while (jsonToken == JsonToken.FIELD_NAME) {
                            jsonParser.nextToken();
                            tokenBuffer.copyCurrentStructure(jsonParser);
                            jsonToken = jsonParser.nextToken();
                        }
                        tokenBuffer.writeEndObject();
                        if (object3.getClass() != this._beanType.getRawClass()) {
                            tokenBuffer.close();
                            throw deserializationContext.mappingException("Can not create polymorphic instances with unwrapped values");
                        }
                        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object3, tokenBuffer);
                    }
                } else if (!propertyValueBuffer.readIdProperty((String)object)) {
                    object2 = this._beanProperties.find((String)object);
                    if (object2 != null) {
                        propertyValueBuffer.bufferProperty((SettableBeanProperty)object2, ((SettableBeanProperty)object2).deserialize(jsonParser, deserializationContext));
                    } else if (this._ignorableProps != null && this._ignorableProps.contains(object)) {
                        jsonParser.skipChildren();
                    } else {
                        tokenBuffer.writeFieldName((String)object);
                        tokenBuffer.copyCurrentStructure(jsonParser);
                        if (this._anySetter != null) {
                            propertyValueBuffer.bufferAnyProperty(this._anySetter, (String)object, this._anySetter.deserialize(jsonParser, deserializationContext));
                        }
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            return null;
        }
        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
    }

    protected Object deserializeWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(jsonParser, deserializationContext);
        }
        return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, this._valueInstantiator.createUsingDefault(deserializationContext));
    }

    protected Object deserializeWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        ExternalTypeHandler externalTypeHandler = this._externalTypeIdHandler.start();
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (jsonParser.getCurrentToken().isScalarValue()) {
                    externalTypeHandler.handleTypePropertyValue(jsonParser, deserializationContext, string, object);
                }
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                jsonParser.skipChildren();
            } else if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, object)) {
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
                    }
                } else {
                    this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
                }
            }
            jsonParser.nextToken();
        }
        return externalTypeHandler.complete(jsonParser, deserializationContext, object);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        ExternalTypeHandler externalTypeHandler = this._externalTypeIdHandler.start();
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartObject();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            block18: {
                Object object;
                String string = jsonParser.getCurrentName();
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
                if (settableBeanProperty != null) {
                    if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, propertyValueBuffer)) {
                        object = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                        if (propertyValueBuffer.assignParameter(settableBeanProperty.getCreatorIndex(), object)) {
                            Object object2;
                            jsonToken = jsonParser.nextToken();
                            try {
                                object2 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), string, deserializationContext);
                                break block18;
                            }
                            while (jsonToken == JsonToken.FIELD_NAME) {
                                jsonParser.nextToken();
                                tokenBuffer.copyCurrentStructure(jsonParser);
                                jsonToken = jsonParser.nextToken();
                            }
                            if (object2.getClass() != this._beanType.getRawClass()) {
                                throw deserializationContext.mappingException("Can not create polymorphic instances with unwrapped values");
                            }
                            return externalTypeHandler.complete(jsonParser, deserializationContext, object2);
                        }
                    }
                } else if (!propertyValueBuffer.readIdProperty(string)) {
                    object = this._beanProperties.find(string);
                    if (object != null) {
                        propertyValueBuffer.bufferProperty((SettableBeanProperty)object, ((SettableBeanProperty)object).deserialize(jsonParser, deserializationContext));
                    } else if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, null)) {
                        if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                            jsonParser.skipChildren();
                        } else if (this._anySetter != null) {
                            propertyValueBuffer.bufferAnyProperty(this._anySetter, string, this._anySetter.deserialize(jsonParser, deserializationContext));
                        }
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            return externalTypeHandler.complete(jsonParser, deserializationContext, propertyValueBuffer, propertyBasedCreator);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            return null;
        }
    }
}

