/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.apache.http.impl.auth;

import com.signalfx.shaded.apache.http.FormattedHeader;
import com.signalfx.shaded.apache.http.Header;
import com.signalfx.shaded.apache.http.HttpRequest;
import com.signalfx.shaded.apache.http.annotation.NotThreadSafe;
import com.signalfx.shaded.apache.http.auth.AuthenticationException;
import com.signalfx.shaded.apache.http.auth.ChallengeState;
import com.signalfx.shaded.apache.http.auth.ContextAwareAuthScheme;
import com.signalfx.shaded.apache.http.auth.Credentials;
import com.signalfx.shaded.apache.http.auth.MalformedChallengeException;
import com.signalfx.shaded.apache.http.protocol.HTTP;
import com.signalfx.shaded.apache.http.protocol.HttpContext;
import com.signalfx.shaded.apache.http.util.Args;
import com.signalfx.shaded.apache.http.util.CharArrayBuffer;
import java.util.Locale;

@NotThreadSafe
public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    private ChallengeState challengeState;

    @Deprecated
    public AuthSchemeBase(ChallengeState challengeState) {
        this.challengeState = challengeState;
    }

    public AuthSchemeBase() {
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        int pos;
        CharArrayBuffer buffer;
        Args.notNull(header, "Header");
        String authheader = header.getName();
        if (authheader.equalsIgnoreCase("WWW-Authenticate")) {
            this.challengeState = ChallengeState.TARGET;
        } else if (authheader.equalsIgnoreCase("Proxy-Authenticate")) {
            this.challengeState = ChallengeState.PROXY;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + authheader);
        }
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            pos = ((FormattedHeader)header).getValuePos();
        } else {
            String s = header.getValue();
            if (s == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            buffer = new CharArrayBuffer(s.length());
            buffer.append(s);
            pos = 0;
        }
        while (pos < buffer.length() && HTTP.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int beginIndex = pos;
        while (pos < buffer.length() && !HTTP.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int endIndex = pos;
        String s = buffer.substring(beginIndex, endIndex);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + s);
        }
        this.parseChallenge(buffer, pos, buffer.length());
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return this.authenticate(credentials, request);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.challengeState != null && this.challengeState == ChallengeState.PROXY;
    }

    public ChallengeState getChallengeState() {
        return this.challengeState;
    }

    public String toString() {
        String name = this.getSchemeName();
        if (name != null) {
            return name.toUpperCase(Locale.US);
        }
        return super.toString();
    }
}

