/*
 * Decompiled with CFR 0.152.
 */
package com.sidneysimmons.gradlepluginexternalproperties.resolver;

import com.sidneysimmons.gradlepluginexternalproperties.resolver.PropertyResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileResolver
implements PropertyResolver {
    private static final Logger log = LoggerFactory.getLogger(PropertiesFileResolver.class);
    private File file;
    private Properties properties;

    public PropertiesFileResolver(File file) {
        this.file = file;
    }

    @Override
    public String resolve(String propertyName) {
        return this.getProperties().getProperty(propertyName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()));
        builder.append("(");
        builder.append("file=" + this.file);
        builder.append(")");
        return builder.toString();
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try (FileInputStream inputStream = new FileInputStream(this.file);){
                this.properties.load(inputStream);
            }
            catch (IOException e) {
                log.debug(MessageFormat.format("Cannot load external properties file. Continuing gracefully. file = {0}", this.file));
            }
        }
        return this.properties;
    }
}

