/*
 * Decompiled with CFR 0.152.
 */
package com.sidneysimmons.gradlepluginexternalproperties.extension;

import com.sidneysimmons.gradlepluginexternalproperties.resolver.PropertiesFileResolver;
import com.sidneysimmons.gradlepluginexternalproperties.resolver.PropertyResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.provider.ListProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalPropertiesExtension {
    private static final Logger log = LoggerFactory.getLogger(ExternalPropertiesExtension.class);
    public static final String NAME = "externalProperties";
    private Project project;
    private ListProperty<PropertyResolver> resolvers;

    public ExternalPropertiesExtension(Project project) {
        this.project = project;
        this.resolvers = project.getObjects().listProperty(PropertyResolver.class);
        this.resolvers.set(new ArrayList());
    }

    public void propertiesFileResolver(File file) {
        this.appendResolver(new PropertiesFileResolver(file));
    }

    public void resolver(PropertyResolver resolver) {
        this.appendResolver(resolver);
    }

    public ListProperty<PropertyResolver> getResolvers() {
        return this.resolvers;
    }

    private void appendResolver(PropertyResolver resolver) {
        List existingResolvers = (List)this.resolvers.get();
        ArrayList<PropertyResolver> newResolvers = new ArrayList<PropertyResolver>(existingResolvers);
        newResolvers.add(resolver);
        this.resolvers.set(newResolvers);
        log.debug("Appended property resolver " + resolver + " as resolver #" + newResolvers.size() + " for project " + this.project + ".");
    }
}

