package com.shopify.keylines.lib;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;

/**
 *  Utility class to send messages to the Shopify Keylines app
 */
public class KeylinesServiceUtility {
    private static final String ACTION_UPDATE_KEYLINES = "com.shopify.keylines.lib.action.UPDATE_KEYLINES";
    private static final String DATA_KEYLINES = "data_keylines";

    private static final String ACTION_CLEAR_KEYLINES = "com.shopify.keylines.lib.action.UPDATE_KEYLINES";

    /**
     * Send a message to the Keylines service to update the keylines shown. This will start the service
     * if it is not already running
     *
     * @param data a {@link KeylinesData} object containing the desired keylines
     */
    public static Intent updateKeylines(KeylinesData data) {
        Intent newIntent = getIntent();
        newIntent.setComponent(new ComponentName("com.shopify.keylines", "com.shopify.keylines.KeylinesBroadcastReceiver"));
        newIntent.putExtra(DATA_KEYLINES, data);
        newIntent.setAction(ACTION_UPDATE_KEYLINES);

        return newIntent;
    }

    /**
     * Send a message to the Keylines service to clear the keylines shown.
     */
    public static Intent clearKeylines() {
        Intent newIntent = getIntent();
        newIntent.setAction(ACTION_CLEAR_KEYLINES);
        return newIntent;
    }

    private static Intent getIntent() {
        Intent newIntent = new Intent();
        newIntent.setComponent(new ComponentName("com.shopify.keylines", "com.shopify.keylines.KeylinesBroadcastReceiver"));
        return newIntent;
    }
}
