package com.shopify.keylines.lib;

import android.content.Context;
import android.content.Intent;

/**
 *  Utility class to send messages to the Shopify Keylines app
 */
public class KeylinesServiceUtility {
    private static final String ACTION_UPDATE_KEYLINES = "com.shopify.keylines.lib.action.UPDATE_KEYLINES";
    private static final String DATA_KEYLINES = "data_keylines";

    /**
     * Send a message to the Keylines service to update the keylines shown. This will start the service
     * if it is not already running
     *
     * @param context context from which to call {@link Context#startService(Intent)}
     * @param data a {@link KeylinesData} object containing the desired keylines
     */
    public static void updateKeylines(Context context, KeylinesData data) {
        Intent newIntent = new Intent();
        newIntent.setAction(ACTION_UPDATE_KEYLINES);
        newIntent.putExtra(DATA_KEYLINES, data);

        context.sendBroadcast(newIntent);
    }
}
