/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice.internal;

import com.segway.robot.sdk.voice.grammar.GrammarConstraint;
import com.segway.robot.sdk.voice.recognition.IRecognitionListener;
import com.segway.robot.sdk.voice.recognition.IWakeupListener;
import java.util.HashMap;

public class Client {
    int mUid;
    final HashMap<String, GrammarConstraint> mGrammarConstraintMap;
    IWakeupListener mWakeupListener;
    IRecognitionListener mRecognitionListener;

    public Client(int uid) {
        this.mUid = uid;
        this.mGrammarConstraintMap = new HashMap();
    }

    public int getUid() {
        return this.mUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGrammarConstraint(GrammarConstraint grammarConstraint) {
        HashMap<String, GrammarConstraint> hashMap = this.mGrammarConstraintMap;
        synchronized (hashMap) {
            this.mGrammarConstraintMap.put(grammarConstraint.getName(), grammarConstraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGrammarConstraint(GrammarConstraint grammarConstraint) {
        HashMap<String, GrammarConstraint> hashMap = this.mGrammarConstraintMap;
        synchronized (hashMap) {
            this.mGrammarConstraintMap.remove(grammarConstraint.getName());
        }
    }

    public GrammarConstraint[] getGrammarConstraints() {
        return (GrammarConstraint[])this.mGrammarConstraintMap.values().toArray();
    }

    public IWakeupListener getWakeupListener() {
        return this.mWakeupListener;
    }

    public void setWakeupListener(IWakeupListener wakeupListener) {
        this.mWakeupListener = wakeupListener;
    }

    public IRecognitionListener getRecognitionListener() {
        return this.mRecognitionListener;
    }

    public void setRecognitionListener(IRecognitionListener recognitionListener) {
        this.mRecognitionListener = recognitionListener;
    }
}

