/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.mobile.sdk.connectivity;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.segway.robot.mobile.sdk.connectivity.BufferMessage;
import com.segway.robot.mobile.sdk.connectivity.MobileException;
import com.segway.robot.mobile.sdk.connectivity.MobileMessageSocket;
import com.segway.robot.mobile.sdk.connectivity.StringMessage;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.baseconnectivity.MessageConnection;
import com.segway.robot.sdk.baseconnectivity.MessageRouter;
import java.util.HashSet;
import java.util.Set;

public class MobileMessageRouter
extends MessageRouter {
    private static final String TAG = "MobileMessageRouter";
    private static MobileMessageRouter mMobileMessageRouter = null;
    private Context mContext = null;
    private MobileMessageSocket mMobileMessageSocket = MobileMessageSocket.getInstance();
    private String mIp = "";

    private MobileMessageRouter() {
    }

    public static synchronized MobileMessageRouter getInstance() {
        if (mMobileMessageRouter == null) {
            mMobileMessageRouter = new MobileMessageRouter();
        }
        return mMobileMessageRouter;
    }

    public void register(MessageRouter.MessageConnectionListener messageConnectionListener) throws Exception {
        if (messageConnectionListener == null) {
            throw new IllegalArgumentException("MessageConnectionListener can't be null!");
        }
        this.mMobileMessageSocket.setConnectionListener(messageConnectionListener);
    }

    public void setConnectionIp(String ip) {
        if (TextUtils.isEmpty((CharSequence)ip)) {
            throw new IllegalArgumentException("IP can't be null!");
        }
        this.mIp = ip;
    }

    public void unregister() {
        mMobileMessageRouter = null;
    }

    public boolean bindService(Context context, ServiceBinder.BindStateListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("Context can't be null!");
        }
        if (listener == null) {
            throw new IllegalArgumentException("BindStateListener can't be null!");
        }
        this.mContext = context.getApplicationContext();
        try {
            this.getMetaData(this.mContext);
        }
        catch (MobileException e) {
            e.printStackTrace();
        }
        this.mMobileMessageSocket.initSocketClient(this.mContext.getPackageName(), this.mIp, listener);
        this.mMobileMessageSocket.connect();
        return false;
    }

    public void unbindService() {
        this.mMobileMessageSocket.disconnect();
    }

    protected void sendBufferMessage(String to, BufferMessage message) throws MobileException {
        this.mMobileMessageSocket.sendMessage(to, message);
    }

    protected void sendStringMessage(String to, StringMessage message) throws MobileException {
        this.mMobileMessageSocket.sendMessage(to, message);
    }

    protected void setListenersReady(String to, MessageConnection.ConnectionStateListener connectionStateListener, MessageConnection.MessageListener messageListener) {
        this.mMobileMessageSocket.setListenersReady(this.mContext.getPackageName(), to, connectionStateListener, messageListener);
    }

    private synchronized void getMetaData(Context context) throws MobileException {
        ApplicationInfo applicationInfo;
        if (context == null) {
            throw new IllegalArgumentException("The context is illegal!");
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            throw new IllegalArgumentException("Cannot get PackageManager.");
        }
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw MobileException.getPackageNameNotFound(e.getMessage(), e);
        }
        if (applicationInfo == null) {
            throw new IllegalArgumentException("Cannot get ApplicationInfo.");
        }
        Bundle data = applicationInfo.metaData;
        if (data == null) {
            throw new IllegalArgumentException("The application metadata is illegal!");
        }
        HashSet<String> metaData = new HashSet<String>();
        for (String key : data.keySet()) {
            String value = data.getString(key);
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            metaData.add(value);
        }
        Log.d((String)TAG, (String)("getMetaData: " + ((Object)metaData).toString()));
        this.setMetaData(context.getPackageName(), metaData);
    }

    private void setMetaData(String packageName, Set set) {
        this.mMobileMessageSocket.setMetaData(packageName, set);
    }
}

