package com.segway.robot.mobile.sdk.connectivity;

import android.util.Log;

import com.segway.robot.sdk.baseconnectivity.MessageUtil;

import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.keepalive.KeepAliveMessageFactory;

/**
 * Created by gaofeng on 2016/4/29.
 */
public class MobileKeepAliveImpl implements KeepAliveMessageFactory {
    private static final String TAG = "MobileKeepAliveImpl";
    private static final boolean DEBUG = false;

    @Override
    public boolean isRequest(IoSession ioSession, Object msg) {
        if (DEBUG) {
            Log.d(TAG, "isRequest: " + ioSession + " message:" + msg);
        }
        return MessageUtil.ROBOT_HEARTBEAT_REQUEST.equals(msg.toString());
    }

    @Override
    public boolean isResponse(IoSession ioSession, Object msg) {
        if (DEBUG) {
            Log.d(TAG, "isResponse: " + ioSession + " message:" + msg);
        }
        return MessageUtil.ROBOT_HEARTBEAT_RESPONSE.equals(msg.toString());
    }

    @Override
    public Object getRequest(IoSession ioSession) {
        if (DEBUG) {
            Log.d(TAG, "getRequest: " + ioSession);
        }
        return MessageUtil.MOBILE_HEARTBEAT_REQUEST;
    }

    @Override
    public Object getResponse(IoSession ioSession, Object msg) {
        if (DEBUG) {
            Log.d(TAG, "getResponse: " + ioSession + " message: " + msg);
        }
        return MessageUtil.MOBILE_HEARTBEAT_RESPONSE;
    }
}