/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.sdk.base.time.StampedData;

public class RelativePoint2DF
implements StampedData,
Parcelable {
    private final long mTimeStamp;
    private final float mDistance;
    private final float mTheta;
    public static final Parcelable.Creator<RelativePoint2DF> CREATOR = new Parcelable.Creator<RelativePoint2DF>(){

        public RelativePoint2DF createFromParcel(Parcel in) {
            return new RelativePoint2DF(in);
        }

        public RelativePoint2DF[] newArray(int size) {
            return new RelativePoint2DF[size];
        }
    };

    public RelativePoint2DF(float distance, float theta, long timestamp) {
        this.mDistance = distance;
        this.mTheta = theta;
        this.mTimeStamp = timestamp;
    }

    protected RelativePoint2DF(Parcel in) {
        this.mTimeStamp = in.readLong();
        this.mDistance = in.readFloat();
        this.mTheta = in.readFloat();
    }

    public float getmDistance() {
        return this.mDistance;
    }

    public float getmTheta() {
        return this.mTheta;
    }

    public long getTimestamp() {
        return this.mTimeStamp;
    }

    public long diff(StampedData source) {
        if (source == null) {
            throw new IllegalArgumentException("diff source is null");
        }
        return source.getTimestamp() - this.getTimestamp();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeStamp);
        dest.writeFloat(this.mDistance);
        dest.writeFloat(this.mTheta);
    }

    public String toString() {
        return "RelativePoint2DF{mTimeStamp=" + this.mTimeStamp + ", mDistance=" + this.mDistance + ", mTheta=" + this.mTheta + '}';
    }
}

