package com.segway.robot.algo.dts;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.algo.CubeF;
import com.segway.robot.algo.PhysicalObject;

/**
 * Person is a person in the world at a certain time
 */
public class Person extends PhysicalObject {
    protected int mId;
    public Person(float x, float y, float z, CubeF bound, int id, long timeStamp) {
        super(x, y, z, bound, timeStamp);
        mId = id;
    }

    /**
     * Get the unique id of the person
     * @return the unique id of the person
     */
    public int getId() {
        return mId;
    }

    public static final Parcelable.Creator<Person> CREATOR = new Parcelable.Creator<Person>() {
        @Override
        public Person createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            float x = in.readFloat();
            float y = in.readFloat();
            float z = in.readFloat();
            CubeF cubeF = in.readParcelable(CubeF.class.getClassLoader());
            int id = in.readInt();
            return new Person(x, y, z, cubeF, id, timestamp);
        }

        @Override
        public Person[] newArray(int size) {
            return new Person[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimeStamp);
        dest.writeFloat(mX);
        dest.writeFloat(mY);
        dest.writeFloat(mZ);
        dest.writeParcelable(mBound, flags);
        dest.writeInt(mId);
    }
}
