package com.segway.robot.algo.generaldts;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.algo.CubeF;
import com.segway.robot.algo.PhysicalObject;
import com.segway.robot.algo.Pose2D;

/**
 * DTSObject is a Object tracked by the GeneralDts module
 */
public class DTSObject extends PhysicalObject {
    private int mId;
    private int mType;
    private float mConfidence;
    private Rect mDrawingRect;
    private Pose2D mRobotPose;
    private float mTheta;
    private float mPitch;

    public DTSObject(float x, float y, float z, CubeF bound, int id, int type, float confidence,
                     Rect drawingRect, Pose2D robotPose, float theta, float pitch, long timeStamp) {
        super(x, y, z, bound, timeStamp);
        mType = type;
        mConfidence = confidence;
        mDrawingRect = drawingRect;
        mRobotPose = robotPose;
        mTheta = theta;
        mPitch = pitch;
        mId = id;
    }

    public DTSObject(DTSObject object) {
        super(object.mX, object.mY, object.mZ, object.mBound, object.mTimeStamp);
        mType = object.mType;
        mConfidence = object.mConfidence;
        mDrawingRect = object.mDrawingRect;
        mRobotPose = object.mRobotPose;
        mTheta = object.mTheta;
        mPitch = object.mPitch;
        mId = object.mId;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(mX);
        dest.writeFloat(mY);
        dest.writeFloat(mZ);
        dest.writeParcelable(mBound, flags);
        dest.writeInt(mId);
        dest.writeInt(mType);
        dest.writeFloat(mConfidence);
        dest.writeParcelable(mDrawingRect, flags);
        dest.writeParcelable(mRobotPose, flags);
        dest.writeFloat(mTheta);
        dest.writeFloat(mPitch);
        dest.writeLong(mTimeStamp);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<DTSObject> CREATOR = new Creator<DTSObject>() {
        @Override
        public DTSObject createFromParcel(Parcel in) {
            float x = in.readFloat();
            float y = in.readFloat();
            float z = in.readFloat();
            CubeF cubeF = in.readParcelable(CubeF.class.getClassLoader());
            int id = in.readInt();
            int type = in.readInt();
            float confidence = in.readFloat();
            Rect rect = in.readParcelable(Rect.class.getClassLoader());
            Pose2D pose = in.readParcelable(Pose2D.class.getClassLoader());
            float theta = in.readFloat();
            float pitch = in.readFloat();
            long timestamp = in.readLong();
            return new DTSObject(x, y, z, cubeF, id, type, confidence, rect, pose, theta, pitch, timestamp);
        }

        @Override
        public DTSObject[] newArray(int size) {
            return new DTSObject[size];
        }
    };

    /**
     * Get the type of the object
     * This method is incomplete and always return 0
     *
     * @return
     */
    public int getType() {
        return mType;
    }

    /**
     * Get the confidence of the object
     *
     * @return confidence of the object
     */
    public float getConfidence() {
        return mConfidence;
    }

    /**
     * Get the drawing rect of the object
     * Drawing rect describe the drawing bound of the person in the picture
     * The max width and height of drawing rect is 640 and 480
     *
     * @return
     */
    public Rect getDrawingRect() {
        return mDrawingRect;
    }

    /**
     * Get the robot pose at this time
     *
     * @return Robot pose
     */
    public Pose2D getRobotPose() {
        return mRobotPose;
    }

    /**
     * Get the yaw angle from robot to the object
     *
     * @return the yaw angle form robot to the object
     */
    public float getTheta() {
        return mTheta;
    }

    /**
     * Get the pitch angle from robot to the object
     *
     * @return the pitch angle from robot to the object
     */
    public float getPitch() {
        return mPitch;
    }

    public int getId() {
        return mId;
    }

    public void setId(int mId) {
        this.mId = mId;
    }

    @Override
    public String toString() {
        return "DTSObject{" +
                "mZ=" + mZ +
                ", mBound=" + mBound +
                ", mTimeStamp=" + mTimeStamp +
                ", mX=" + mX +
                ", mY=" + mY +
                ", mId=" + mId +
                ", mType=" + mType +
                ", mConfidence=" + mConfidence +
                ", mDrawingRect=" + mDrawingRect +
                ", mRobotPose=" + mRobotPose +
                ", mTheta=" + mTheta +
                ", mPitch=" + mPitch +
                '}';
    }
}
