package com.segway.robot.algo.minicontroller;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by ark338 on 2017/3/3.
 */

public class CheckPoint implements Parcelable {
    public static final long ID_NONE = -1;
    public static final float ORIENTATION_IGNORE = Float.MAX_VALUE;
    private long mId;
    private float mX;
    private float mY;
    private float mOrientation;

    public CheckPoint(long id, float x, float y) {
        this.mId = id;
        this.mX = x;
        this.mY = y;
        this.mOrientation = ORIENTATION_IGNORE;
    }

    public CheckPoint(long id, float x, float y, float orientation) {
        this.mId = id;
        this.mX = x;
        this.mY = y;
        this.mOrientation = orientation;
    }

    public CheckPoint(float x, float y) {
        this.mId = ID_NONE;
        this.mX = x;
        this.mY = y;
        this.mOrientation = ORIENTATION_IGNORE;
    }

    public CheckPoint(float x, float y, float orientation) {
        this.mId = ID_NONE;
        this.mX = x;
        this.mY = y;
        this.mOrientation = orientation;
    }

    protected CheckPoint(Parcel in) {
        mId = in.readLong();
        mX = in.readFloat();
        mY = in.readFloat();
        mOrientation = in.readFloat();
    }

    public static final Creator<CheckPoint> CREATOR = new Creator<CheckPoint>() {
        @Override
        public CheckPoint createFromParcel(Parcel in) {
            return new CheckPoint(in);
        }

        @Override
        public CheckPoint[] newArray(int size) {
            return new CheckPoint[size];
        }
    };

    public long getId() {
        return mId;
    }

    void setId(long id) {
        mId = id;
    }

    public float getX() {
        return mX;
    }

    public void setX(float x) {
        mX = x;
    }

    public float getY() {
        return mY;
    }

    public void setY(float y) {
        mY = y;
    }

    public float getOrientation() {
        return mOrientation;
    }

    public void setOrientation(float orientation) {
        mOrientation = orientation;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mId);
        dest.writeFloat(mX);
        dest.writeFloat(mY);
        dest.writeFloat(mOrientation);
    }

    @Override
    public String toString() {
        return "CheckPoint:" +
                " mId=" + mId +
                " mX=" + mX +
                " mY=" + mY +
                " mOrientation=" + mOrientation;
    }
}
