package com.segway.robot.algo.dts;

/**
 * Callback interface for being notified that a new state of person tracking
 */
public interface PersonTrackingListener {
    /**
     * This method is called when one or more person is tracking
     * @param person the person is tracking
     */
    void onPersonTracking(DTSPerson person);

    /**
     * This method is called when an error is occurred while tracking
     * Timeout is one of the most common error
     * @param errorCode code of error
     * @param message message of error
     */
    void onPersonTrackingError(int errorCode, String message);
}
