package com.segway.robot.algo.tf;

/**
 * Created by Yusen.QIN on 2017/11/10.
 */

public class Matrix4 {
    public static final int M00 = 0;
    public static final int M01 = 4;
    public static final int M02 = 8;
    public static final int M03 = 12;
    public static final int M10 = 1;
    public static final int M11 = 5;
    public static final int M12 = 9;
    public static final int M13 = 13;
    public static final int M20 = 2;
    public static final int M21 = 6;
    public static final int M22 = 10;
    public static final int M23 = 14;
    public static final int M30 = 3;
    public static final int M31 = 7;
    public static final int M32 = 11;
    public static final int M33 = 15;
    public final float val[] = new float[16];
    public Matrix4 () {
        val[M00] = 1f;
        val[M11] = 1f;
        val[M22] = 1f;
        val[M33] = 1f;
    }

    public Matrix4 setTranslation (float x, float y, float z) {
        val[M03] = x;
        val[M13] = y;
        val[M23] = z;
        return this;
    }

    public Matrix4 setQuaternion (float x, float y, float z, float w) {
        return this.set(0,0,0, x, y, z, w);
    }

    public Matrix4 set (float translationX, float translationY, float translationZ, float quaternionX, float quaternionY,
                        float quaternionZ, float quaternionW) {
        final float xs = quaternionX * 2f, ys = quaternionY * 2f, zs = quaternionZ * 2f;
        final float wx = quaternionW * xs, wy = quaternionW * ys, wz = quaternionW * zs;
        final float xx = quaternionX * xs, xy = quaternionX * ys, xz = quaternionX * zs;
        final float yy = quaternionY * ys, yz = quaternionY * zs, zz = quaternionZ * zs;

        val[M00] = (1.0f - (yy + zz));
        val[M01] = (xy - wz);
        val[M02] = (xz + wy);
        val[M03] = translationX;

        val[M10] = (xy + wz);
        val[M11] = (1.0f - (xx + zz));
        val[M12] = (yz - wx);
        val[M13] = translationY;

        val[M20] = (xz - wy);
        val[M21] = (yz + wx);
        val[M22] = (1.0f - (xx + yy));
        val[M23] = translationZ;

        val[M30] = 0.f;
        val[M31] = 0.f;
        val[M32] = 0.f;
        val[M33] = 1.0f;
        return this;
    }

    public float vectorLen (float x, float y, float z) {
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public Quaternion getNormalizedQuaternion(float xx, float xy, float xz, float yx, float yy, float yz, float zx,
                                              float zy, float zz){

        final float lx = 1f / vectorLen(xx, xy, xz);
        final float ly = 1f / vectorLen(yx, yy, yz);
        final float lz = 1f / vectorLen(zx, zy, zz);
        xx *= lx;
        xy *= lx;
        xz *= lx;
        yx *= ly;
        yy *= ly;
        yz *= ly;
        zx *= lz;
        zy *= lz;
        zz *= lz;

        final float t = xx + yy + zz;
        float x,y,z,w;
        // we protect the division by s by ensuring that s>=1
        if (t >= 0) { // |w| >= .5
            float s = (float)Math.sqrt(t + 1); // |s|>=1 ...
            w = 0.5f * s;
            s = 0.5f / s; // so this division isn't bad
            x = (zy - yz) * s;
            y = (xz - zx) * s;
            z = (yx - xy) * s;
        } else if ((xx > yy) && (xx > zz)) {
            float s = (float)Math.sqrt(1.0 + xx - yy - zz); // |s|>=1
            x = s * 0.5f; // |x| >= .5
            s = 0.5f / s;
            y = (yx + xy) * s;
            z = (xz + zx) * s;
            w = (zy - yz) * s;
        } else if (yy > zz) {
            float s = (float)Math.sqrt(1.0 + yy - xx - zz); // |s|>=1
            y = s * 0.5f; // |y| >= .5
            s = 0.5f / s;
            x = (yx + xy) * s;
            z = (zy + yz) * s;
            w = (xz - zx) * s;
        } else {
            float s = (float)Math.sqrt(1.0 + zz - xx - yy); // |s|>=1
            z = s * 0.5f; // |z| >= .5
            s = 0.5f / s;
            x = (xz + zx) * s;
            y = (zy + yz) * s;
            w = (yx - xy) * s;
        }

        Quaternion q = new Quaternion(x,y,z,w);
        return q;
    }

    public Quaternion getQuaternion(){
        Quaternion q = getNormalizedQuaternion(val[M00], val[M01], val[M02],
                                               val[M10], val[M11], val[M12],
                                               val[M20], val[M21], val[M22]);
        return q;
    }

    public Translation getTranslation () {
        Translation t = new Translation(val[M03], val[M13], val[M23]);
        return t;
    }

}
