/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.webkit.WebView;
import androidx.appcompat.app.AppCompatActivity;
import com.salesforce.barcodescannerplugin.BarcodeErrorEvent;
import com.salesforce.barcodescannerplugin.BarcodePluginActivity;
import com.salesforce.barcodescannerplugin.BarcodeScannedEvent;
import com.salesforce.barcodescannerplugin.BarcodeScanner;
import com.salesforce.barcodescannerplugin.BarcodeScannerOptions;
import com.salesforce.barcodescannerplugin.BarcodeScannerResult;
import com.salesforce.nimbus.Bridge;
import com.salesforce.nimbus.NimbusExtension;
import com.salesforce.nimbus.PluginOptions;
import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PluginOptions(name="barcodeScanner")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005JN\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072:\u0010\u0013\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\tH\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000RB\u0010\b\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodeScannerPlugin;", "Lcom/salesforce/nimbus/NimbusExtension;", "Lcom/salesforce/barcodescannerplugin/BarcodeScanner;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "(Landroidx/appcompat/app/AppCompatActivity;)V", "barcodeOptions", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerOptions;", "scannerCallback", "Lkotlin/Function2;", "Lcom/salesforce/barcodescannerplugin/BarcodeScannerResult;", "Lkotlin/ParameterName;", "name", "barcode", "", "error", "", "beginCapture", "options", "callback", "endCapture", "onMessageEvent", "event", "Lcom/salesforce/barcodescannerplugin/BarcodeErrorEvent;", "Lcom/salesforce/barcodescannerplugin/BarcodeScannedEvent;", "resumeCapture", "startScanner", "barcodescanner_release"})
public final class BarcodeScannerPlugin
implements NimbusExtension,
BarcodeScanner {
    private Function2<? super BarcodeScannerResult, ? super String, Unit> scannerCallback;
    private BarcodeScannerOptions barcodeOptions;
    private final AppCompatActivity activity;

    @Override
    public void beginCapture(@Nullable BarcodeScannerOptions options, @NotNull Function2<? super BarcodeScannerResult, ? super String, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        BarcodeScannerPlugin barcodeScannerPlugin = this;
        BarcodeScannerOptions barcodeScannerOptions = options;
        if (barcodeScannerOptions == null) {
            BarcodeScannerPlugin barcodeScannerPlugin2 = barcodeScannerPlugin;
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            barcodeScannerPlugin = barcodeScannerPlugin2;
            List list2 = list;
            barcodeScannerOptions = new BarcodeScannerOptions(list2);
        }
        barcodeScannerPlugin.barcodeOptions = barcodeScannerOptions;
        this.scannerCallback = callback;
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.startScanner();
    }

    @Override
    public void resumeCapture() {
        this.startScanner();
    }

    @Override
    public void endCapture() {
        EventBus.getDefault().unregister((Object)this);
    }

    @Subscribe(sticky=true, threadMode=ThreadMode.MAIN)
    public final void onMessageEvent(@NotNull BarcodeScannedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Function2<? super BarcodeScannerResult, ? super String, Unit> function2 = this.scannerCallback;
        if (function2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scannerCallback");
        }
        function2.invoke((Object)event.getBarcode(), null);
        EventBus.getDefault().removeStickyEvent((Object)event);
    }

    @Subscribe(sticky=true, threadMode=ThreadMode.MAIN)
    public final void onMessageEvent(@NotNull BarcodeErrorEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Function2<? super BarcodeScannerResult, ? super String, Unit> function2 = this.scannerCallback;
        if (function2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scannerCallback");
        }
        function2.invoke(null, (Object)event.getErrorMessage());
        EventBus.getDefault().removeStickyEvent((Object)event);
    }

    private final void startScanner() {
        this.activity.getSupportFragmentManager();
        Intent intent = new Intent((Context)this.activity, BarcodePluginActivity.class);
        Bundle bundle = new Bundle();
        BarcodeScannerOptions barcodeScannerOptions = this.barcodeOptions;
        if (barcodeScannerOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"barcodeOptions");
        }
        bundle.putSerializable("OptionsValue", (Serializable)barcodeScannerOptions);
        intent.putExtras(bundle);
        this.activity.startActivity(intent);
    }

    public BarcodeScannerPlugin(@NotNull AppCompatActivity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        this.activity = activity;
    }

    public void cleanup(@NotNull WebView webView) {
        Intrinsics.checkParameterIsNotNull((Object)webView, (String)"webView");
        NimbusExtension.DefaultImpls.cleanup((NimbusExtension)this, (WebView)webView);
    }

    public void cleanup(@NotNull WebView webView, @NotNull Bridge bridge) {
        Intrinsics.checkParameterIsNotNull((Object)webView, (String)"webView");
        Intrinsics.checkParameterIsNotNull((Object)bridge, (String)"bridge");
        NimbusExtension.DefaultImpls.cleanup((NimbusExtension)this, (WebView)webView, (Bridge)bridge);
    }

    public void customize(@NotNull WebView webView) {
        Intrinsics.checkParameterIsNotNull((Object)webView, (String)"webView");
        NimbusExtension.DefaultImpls.customize((NimbusExtension)this, (WebView)webView);
    }

    public void customize(@NotNull WebView webView, @NotNull Bridge bridge) {
        Intrinsics.checkParameterIsNotNull((Object)webView, (String)"webView");
        Intrinsics.checkParameterIsNotNull((Object)bridge, (String)"bridge");
        NimbusExtension.DefaultImpls.customize((NimbusExtension)this, (WebView)webView, (Bridge)bridge);
    }
}

