/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.barcodescannerplugin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.salesforce.barcodescannerplugin.BarcodeAnalyzer;
import com.salesforce.barcodescannerplugin.BarcodePluginActivity;
import com.salesforce.barcodescannerplugin.BarcodeScannedEvent;
import com.salesforce.barcodescannerplugin.BarcodeScannerOptions;
import com.salesforce.barcodescannerplugin.BarcodeScannerResult;
import com.salesforce.barcodescannerplugin.BarcodeType;
import com.salesforce.barcodescannerplugin.R;
import com.salesforce.barcodescannerplugin.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u0017H\u0014J-\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00132\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodePluginActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "barcodeAnalyzer", "Lcom/salesforce/barcodescannerplugin/BarcodeAnalyzer;", "camera", "Landroidx/camera/core/Camera;", "cameraProviderFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "executor", "Ljava/util/concurrent/ExecutorService;", "imageAnalysis", "Landroidx/camera/core/ImageAnalysis;", "preview", "Landroidx/camera/core/Preview;", "viewFinder", "Landroidx/camera/view/PreviewView;", "getAspectRation", "", "width", "height", "initializeCamera", "", "onBarcodeFound", "barcode", "Lcom/google/firebase/ml/vision/barcode/FirebaseVisionBarcode;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onRequestPermissionsResult", "requestCode", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "Companion", "barcodescanner_release"})
public final class BarcodePluginActivity
extends AppCompatActivity {
    private ListenableFuture<ProcessCameraProvider> cameraProviderFuture;
    private PreviewView viewFinder;
    private ExecutorService executor;
    private BarcodeAnalyzer barcodeAnalyzer;
    private Preview preview;
    private ImageAnalysis imageAnalysis;
    private Camera camera;
    private static final String TAG = "BarcodePluginActivity";
    @NotNull
    public static final String OPTIONS_VALUE = "OptionsValue";
    private static final double RATIO_4_3_VALUE = 1.3333333333333333;
    private static final double RATIO_16_9_VALUE = 1.7777777777777777;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.barcode_plugin_activity);
        View view = this.findViewById(R.id.preview_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.preview_view)");
        this.viewFinder = (PreviewView)view;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        this.executor = executorService;
        if (!Utils.INSTANCE.arePermissionsGranted((Activity)this)) {
            Utils.INSTANCE.requestPermissions((Activity)this);
        } else {
            PreviewView previewView = this.viewFinder;
            if (previewView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewFinder");
            }
            previewView.post(new Runnable(this){
                final /* synthetic */ BarcodePluginActivity this$0;

                public final void run() {
                    BarcodePluginActivity.access$initializeCamera(this.this$0);
                }
                {
                    this.this$0 = barcodePluginActivity;
                }
            });
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        ExecutorService executorService = this.executor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
        }
        executorService.shutdown();
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (Utils.INSTANCE.arePermissionsGranted((Activity)this)) {
            PreviewView previewView = this.viewFinder;
            if (previewView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewFinder");
            }
            previewView.post(new Runnable(this){
                final /* synthetic */ BarcodePluginActivity this$0;

                public final void run() {
                    BarcodePluginActivity.access$initializeCamera(this.this$0);
                }
                {
                    this.this$0 = barcodePluginActivity;
                }
            });
        }
    }

    private final int getAspectRation(int width, int height) {
        boolean bl = false;
        double d = Math.max(width, height);
        bl = false;
        int n = Math.min(width, height);
        double previewRatio = d / (double)n;
        double d2 = previewRatio - 1.3333333333333333;
        boolean bl2 = false;
        double d3 = Math.abs(d2);
        d2 = previewRatio - 1.7777777777777777;
        d = d3;
        bl2 = false;
        double d4 = Math.abs(d2);
        if (d <= d4) {
            return 0;
        }
        return 1;
    }

    private final void initializeCamera() {
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        BarcodeScannerOptions barcodeScannerOptions = (BarcodeScannerOptions)(bundle != null ? bundle.getSerializable(OPTIONS_VALUE) : null);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        boolean bl = false;
        boolean bl2 = false;
        DisplayMetrics it = displayMetrics;
        boolean bl3 = false;
        PreviewView previewView = this.viewFinder;
        if (previewView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewFinder");
        }
        previewView.getDisplay().getRealMetrics(it);
        DisplayMetrics metrics = displayMetrics;
        PreviewView previewView2 = this.viewFinder;
        if (previewView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewFinder");
        }
        Display display = previewView2.getDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"viewFinder.display");
        int rotation = display.getRotation();
        int screenAspectRatio = this.getAspectRation(metrics.widthPixels, metrics.heightPixels);
        Intrinsics.checkExpressionValueIsNotNull((Object)((ImageView)this._$_findCachedViewById(R.id.barcode_frame)), (String)"barcode_frame");
        ((ImageView)this._$_findCachedViewById(R.id.barcode_frame)).getLayoutParams().height = metrics.heightPixels / 2;
        Intrinsics.checkExpressionValueIsNotNull((Object)((ImageView)this._$_findCachedViewById(R.id.barcode_frame)), (String)"barcode_frame");
        ((ImageView)this._$_findCachedViewById(R.id.barcode_frame)).getLayoutParams().width = metrics.widthPixels / 2;
        ((ImageView)this._$_findCachedViewById(R.id.barcode_frame)).requestLayout();
        ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)((Context)this));
        Intrinsics.checkExpressionValueIsNotNull((Object)listenableFuture, (String)"ProcessCameraProvider.getInstance(this)");
        this.cameraProviderFuture = listenableFuture;
        CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(1).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cameraSelector, (String)"CameraSelector.Builder()\u2026LENS_FACING_BACK).build()");
        CameraSelector cameraSelector2 = cameraSelector;
        ListenableFuture<ProcessCameraProvider> listenableFuture2 = this.cameraProviderFuture;
        if (listenableFuture2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraProviderFuture");
        }
        listenableFuture2.addListener(new Runnable(this, screenAspectRatio, rotation, barcodeScannerOptions, cameraSelector2){
            final /* synthetic */ BarcodePluginActivity this$0;
            final /* synthetic */ int $screenAspectRatio;
            final /* synthetic */ int $rotation;
            final /* synthetic */ BarcodeScannerOptions $barcodeScannerOptions;
            final /* synthetic */ CameraSelector $cameraSelector;

            public final void run() {
                ProcessCameraProvider cameraProvider = (ProcessCameraProvider)BarcodePluginActivity.access$getCameraProviderFuture$p(this.this$0).get();
                Preview.Builder builder = new Preview.Builder();
                BarcodePluginActivity barcodePluginActivity = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                Preview.Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.setTargetAspectRatio(this.$screenAspectRatio);
                $this$apply.setTargetRotation(this.$rotation);
                Preview.Builder builder2 = builder;
                BarcodePluginActivity.access$setPreview$p(barcodePluginActivity, builder2.build());
                Preview preview = BarcodePluginActivity.access$getPreview$p(this.this$0);
                if (preview != null) {
                    preview.setSurfaceProvider(BarcodePluginActivity.access$getViewFinder$p(this.this$0).getPreviewSurfaceProvider());
                }
                BarcodePluginActivity.access$setBarcodeAnalyzer$p(this.this$0, new BarcodeAnalyzer((Function1<? super List<? extends FirebaseVisionBarcode>, Unit>)((Function1)new Function1<List<? extends FirebaseVisionBarcode>, Unit>(this){
                    final /* synthetic */ initializeCamera.1 this$0;

                    public final void invoke(@NotNull List<? extends FirebaseVisionBarcode> qrCodes) {
                        Intrinsics.checkParameterIsNotNull(qrCodes, (String)"qrCodes");
                        Collection collection = qrCodes;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            FirebaseVisionBarcode barcode = (FirebaseVisionBarcode)CollectionsKt.first(qrCodes);
                            BarcodePluginActivity.access$onBarcodeFound(this.this$0.this$0, barcode);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), this.$barcodeScannerOptions));
                builder = new ImageAnalysis.Builder().setTargetAspectRatio(this.$screenAspectRatio).setBackpressureStrategy(0).setImageQueueDepth(0).setTargetRotation(this.$rotation).build();
                barcodePluginActivity = this.this$0;
                bl = false;
                bl2 = false;
                Preview.Builder it = builder;
                boolean bl4 = false;
                it.setAnalyzer((Executor)BarcodePluginActivity.access$getExecutor$p(this.this$0), (ImageAnalysis.Analyzer)BarcodePluginActivity.access$getBarcodeAnalyzer$p(this.this$0));
                builder2 = builder;
                BarcodePluginActivity.access$setImageAnalysis$p(barcodePluginActivity, (ImageAnalysis)builder2);
                cameraProvider.unbindAll();
                try {
                    BarcodePluginActivity.access$setCamera$p(this.this$0, cameraProvider.bindToLifecycle((LifecycleOwner)this.this$0, this.$cameraSelector, new UseCase[]{(UseCase)BarcodePluginActivity.access$getPreview$p(this.this$0), (UseCase)BarcodePluginActivity.access$getImageAnalysis$p(this.this$0)}));
                }
                catch (Exception exc) {
                    Utils.INSTANCE.postError("BarcodePluginActivity", "Failed to start camera", exc);
                }
            }
            {
                this.this$0 = barcodePluginActivity;
                this.$screenAspectRatio = n;
                this.$rotation = n2;
                this.$barcodeScannerOptions = barcodeScannerOptions;
                this.$cameraSelector = cameraSelector;
            }
        }, ContextCompat.getMainExecutor((Context)((Context)this)));
        ((ImageView)this._$_findCachedViewById(R.id.close_button)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ BarcodePluginActivity this$0;

            public final void onClick(View it) {
                this.this$0.onBackPressed();
            }
            {
                this.this$0 = barcodePluginActivity;
            }
        });
    }

    private final void onBarcodeFound(FirebaseVisionBarcode barcode) {
        EventBus eventBus = EventBus.getDefault();
        BarcodeType barcodeType = BarcodeType.Companion.fromVisionBarcode(barcode.getFormat());
        String string = barcode.getDisplayValue();
        if (string == null) {
            string = "";
        }
        eventBus.postSticky((Object)new BarcodeScannedEvent(new BarcodeScannerResult(barcodeType, string)));
        this.finish();
    }

    public static final /* synthetic */ void access$initializeCamera(BarcodePluginActivity $this) {
        $this.initializeCamera();
    }

    public static final /* synthetic */ ListenableFuture access$getCameraProviderFuture$p(BarcodePluginActivity $this) {
        ListenableFuture<ProcessCameraProvider> listenableFuture = $this.cameraProviderFuture;
        if (listenableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraProviderFuture");
        }
        return listenableFuture;
    }

    public static final /* synthetic */ void access$setCameraProviderFuture$p(BarcodePluginActivity $this, ListenableFuture listenableFuture) {
        $this.cameraProviderFuture = listenableFuture;
    }

    public static final /* synthetic */ Preview access$getPreview$p(BarcodePluginActivity $this) {
        return $this.preview;
    }

    public static final /* synthetic */ void access$setPreview$p(BarcodePluginActivity $this, Preview preview) {
        $this.preview = preview;
    }

    public static final /* synthetic */ PreviewView access$getViewFinder$p(BarcodePluginActivity $this) {
        PreviewView previewView = $this.viewFinder;
        if (previewView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewFinder");
        }
        return previewView;
    }

    public static final /* synthetic */ void access$setViewFinder$p(BarcodePluginActivity $this, PreviewView previewView) {
        $this.viewFinder = previewView;
    }

    public static final /* synthetic */ BarcodeAnalyzer access$getBarcodeAnalyzer$p(BarcodePluginActivity $this) {
        BarcodeAnalyzer barcodeAnalyzer = $this.barcodeAnalyzer;
        if (barcodeAnalyzer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"barcodeAnalyzer");
        }
        return barcodeAnalyzer;
    }

    public static final /* synthetic */ void access$setBarcodeAnalyzer$p(BarcodePluginActivity $this, BarcodeAnalyzer barcodeAnalyzer) {
        $this.barcodeAnalyzer = barcodeAnalyzer;
    }

    public static final /* synthetic */ void access$onBarcodeFound(BarcodePluginActivity $this, FirebaseVisionBarcode barcode) {
        $this.onBarcodeFound(barcode);
    }

    public static final /* synthetic */ ImageAnalysis access$getImageAnalysis$p(BarcodePluginActivity $this) {
        return $this.imageAnalysis;
    }

    public static final /* synthetic */ void access$setImageAnalysis$p(BarcodePluginActivity $this, ImageAnalysis imageAnalysis) {
        $this.imageAnalysis = imageAnalysis;
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(BarcodePluginActivity $this) {
        ExecutorService executorService = $this.executor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
        }
        return executorService;
    }

    public static final /* synthetic */ void access$setExecutor$p(BarcodePluginActivity $this, ExecutorService executorService) {
        $this.executor = executorService;
    }

    public static final /* synthetic */ Camera access$getCamera$p(BarcodePluginActivity $this) {
        return $this.camera;
    }

    public static final /* synthetic */ void access$setCamera$p(BarcodePluginActivity $this, Camera camera) {
        $this.camera = camera;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/salesforce/barcodescannerplugin/BarcodePluginActivity$Companion;", "", "()V", "OPTIONS_VALUE", "", "RATIO_16_9_VALUE", "", "RATIO_4_3_VALUE", "TAG", "barcodescanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

