/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.cc.types;

import com.rometools.rome.feed.impl.EqualsBean;
import com.rometools.rome.feed.impl.ToStringBean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class License {
    private static final String CC_START = "http://creativecommons.org/licenses/";
    private static final Map<String, License> lookupLicense = new ConcurrentHashMap<String, License>();
    private static final Logger LOG = LoggerFactory.getLogger(License.class);
    public static final License NO_DERIVS = new License("http://creativecommons.org/licenses/nd/1.0/", new Behaviour[0], new Behaviour[]{Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    public static final License NO_DERIVS_NONCOMMERCIAL = new License("http://creativecommons.org/licenses/nd-nc/1.0/", new Behaviour[]{Behaviour.NONCOMMERCIAL}, new Behaviour[]{Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    public static final License NONCOMMERCIAL = new License("http://creativecommons.org/licenses/nc/1.0/", new Behaviour[]{Behaviour.NONCOMMERCIAL}, new Behaviour[]{Behaviour.DERIVATIVE, Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    public static final License SHARE_ALIKE = new License("http://creativecommons.org/licenses/sa/1.0/", new Behaviour[]{Behaviour.COPYLEFT}, new Behaviour[]{Behaviour.DERIVATIVE, Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    public static final License SHARE_ALIKE_NONCOMMERCIAL = new License("http://creativecommons.org/licenses/nc-sa/1.0/", new Behaviour[]{Behaviour.COPYLEFT, Behaviour.NONCOMMERCIAL}, new Behaviour[]{Behaviour.DERIVATIVE, Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    public static final License SHARE_ALIKE_ATTRIBUTION = new License("http://creativecommons.org/licenses/by-sa/2.5/", new Behaviour[]{Behaviour.COPYLEFT, Behaviour.ATTRIBUTION}, new Behaviour[]{Behaviour.DERIVATIVE, Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    public static final License SHARE_ALIKE_NONCOMMERCIAL_ATTRIBUTION = new License("http://creativecommons.org/licenses/by-nc-sa/2.5/", new Behaviour[]{Behaviour.COPYLEFT, Behaviour.ATTRIBUTION, Behaviour.NONCOMMERCIAL}, new Behaviour[]{Behaviour.DERIVATIVE, Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    public static final License NONCOMMERCIAL_ATTRIBUTION = new License("http://creativecommons.org/licenses/by-nc/2.5/", new Behaviour[]{Behaviour.ATTRIBUTION, Behaviour.NONCOMMERCIAL}, new Behaviour[]{Behaviour.DERIVATIVE, Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    public static final License NONCOMMERCIAL_ATTRIBUTION_NO_DERIVS = new License("http://creativecommons.org/licenses/by-nc-nd/2.5/", new Behaviour[]{Behaviour.ATTRIBUTION, Behaviour.NONCOMMERCIAL}, new Behaviour[]{Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    public static final License ATTRIBUTION_NO_DERIVS = new License("http://creativecommons.org/licenses/by-nd/2.5/", new Behaviour[]{Behaviour.ATTRIBUTION}, new Behaviour[]{Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    public static final License ATTRIBUTION = new License("http://creativecommons.org/licenses/by/2.5/", new Behaviour[]{Behaviour.ATTRIBUTION}, new Behaviour[]{Behaviour.DERIVATIVE, Behaviour.DISTRIBUTION, Behaviour.REPRODUCTION});
    private final String uri;
    private final Behaviour[] permits;
    private final Behaviour[] requires;

    public License(String uri, Behaviour[] requires, Behaviour[] permits) {
        this.requires = requires;
        this.permits = permits;
        this.uri = uri;
        lookupLicense.put(uri, this);
        if (this.uri.endsWith("/")) {
            lookupLicense.put(uri.substring(0, this.uri.lastIndexOf("/")), this);
        }
    }

    public static License findByValue(String uri) {
        License found = lookupLicense.get(uri);
        if (found == null && uri.startsWith("http://") && uri.toLowerCase().indexOf("creativecommons.org") != -1) {
            Iterator<String> it = lookupLicense.keySet().iterator();
            while (it.hasNext() && found == null) {
                String key = it.next();
                try {
                    if (!key.startsWith(CC_START)) continue;
                    String licensePath = key.substring(CC_START.length(), key.length());
                    StringTokenizer tok = new StringTokenizer(licensePath, "/");
                    String license = tok.nextToken();
                    if (uri.toLowerCase().indexOf("creativecommons.org/licenses/" + license) == -1) continue;
                    License current = lookupLicense.get(key);
                    found = new License(uri, current.getRequires(), current.getPermits());
                }
                catch (Exception e) {
                    LOG.error("Error", (Throwable)e);
                }
            }
        }
        if (found == null) {
            found = new License(uri, null, null);
        }
        return found;
    }

    static void clear() {
        lookupLicense.clear();
    }

    public Behaviour[] getPermits() {
        return this.permits;
    }

    public Behaviour[] getRequires() {
        return this.requires;
    }

    public String toString() {
        return ToStringBean.toString(License.class, (Object)this);
    }

    public String getValue() {
        return this.uri;
    }

    public boolean equals(Object obj) {
        return EqualsBean.beanEquals(License.class, (Object)this, (Object)obj);
    }

    public int hashCode() {
        return EqualsBean.beanHashCode((Object)this);
    }

    public static class Behaviour {
        private static final Map<String, Behaviour> lookup = new HashMap<String, Behaviour>();
        public static final Behaviour REPRODUCTION = new Behaviour("http://web.resource.org/cc/Reproduction");
        public static final Behaviour DISTRIBUTION = new Behaviour("http://web.resource.org/cc/Distribution");
        public static final Behaviour DERIVATIVE = new Behaviour("http://web.resource.org/cc/DerivativeWorks");
        public static final Behaviour NOTICE = new Behaviour("http://web.resource.org/cc/Notice");
        public static final Behaviour ATTRIBUTION = new Behaviour("http://web.resource.org/cc/Attribution");
        public static final Behaviour COPYLEFT = new Behaviour("http://web.resource.org/cc/Copyleft");
        public static final Behaviour NONCOMMERCIAL = new Behaviour("http://web.resource.org/cc/Noncommercial");
        private final String uri;

        private Behaviour(String uri) {
            this.uri = uri;
            lookup.put(uri, this);
        }

        public static Behaviour findByValue(String uri) {
            return lookup.get(uri);
        }

        public String toString() {
            return this.uri;
        }
    }
}

