/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.base.io;

import com.rometools.modules.base.CustomTag;
import com.rometools.modules.base.CustomTagImpl;
import com.rometools.modules.base.CustomTagsImpl;
import com.rometools.modules.base.io.GoogleBaseParser;
import com.rometools.modules.base.types.DateTimeRange;
import com.rometools.modules.base.types.FloatUnit;
import com.rometools.modules.base.types.IntUnit;
import com.rometools.modules.base.types.ShortDate;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTagParser
implements ModuleParser {
    private static final Logger LOG = LoggerFactory.getLogger(CustomTagParser.class);
    static final Namespace NS = Namespace.getNamespace((String)"g-custom", (String)"http://base.google.com/cns/1.0");

    public Module parse(Element element, Locale locale) {
        CustomTagsImpl module = new CustomTagsImpl();
        ArrayList<CustomTag> tags = new ArrayList<CustomTag>();
        List elements = element.getChildren();
        for (Element child : elements) {
            if (!child.getNamespace().equals((Object)NS)) continue;
            String type = child.getAttributeValue("type");
            try {
                if (type == null) continue;
                if (type.equals("string")) {
                    tags.add(new CustomTagImpl(child.getName(), child.getText()));
                    continue;
                }
                if (type.equals("int")) {
                    tags.add(new CustomTagImpl(child.getName(), Integer.valueOf(child.getTextTrim())));
                    continue;
                }
                if (type.equals("float")) {
                    tags.add(new CustomTagImpl(child.getName(), Float.valueOf(child.getTextTrim())));
                    continue;
                }
                if (type.equals("intUnit")) {
                    tags.add(new CustomTagImpl(child.getName(), new IntUnit(child.getTextTrim())));
                    continue;
                }
                if (type.equals("floatUnit")) {
                    tags.add(new CustomTagImpl(child.getName(), new FloatUnit(child.getTextTrim())));
                    continue;
                }
                if (type.equals("date")) {
                    try {
                        tags.add(new CustomTagImpl(child.getName(), new ShortDate(GoogleBaseParser.SHORT_DT_FMT.parse(child.getTextTrim()))));
                    }
                    catch (ParseException e) {
                        LOG.warn("Unable to parse date type on " + child.getName(), (Throwable)e);
                    }
                    continue;
                }
                if (type.equals("dateTime")) {
                    try {
                        tags.add(new CustomTagImpl(child.getName(), GoogleBaseParser.LONG_DT_FMT.parse(child.getTextTrim())));
                    }
                    catch (ParseException e) {
                        LOG.warn("Unable to parse date type on " + child.getName(), (Throwable)e);
                    }
                    continue;
                }
                if (type.equals("dateTimeRange")) {
                    try {
                        tags.add(new CustomTagImpl(child.getName(), new DateTimeRange(GoogleBaseParser.LONG_DT_FMT.parse(child.getChild("start", NS).getText().trim()), GoogleBaseParser.LONG_DT_FMT.parse(child.getChild("end", NS).getText().trim()))));
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to parse date type on " + child.getName(), (Throwable)e);
                    }
                    continue;
                }
                if (type.equals("url")) {
                    try {
                        tags.add(new CustomTagImpl(child.getName(), new URL(child.getTextTrim())));
                    }
                    catch (MalformedURLException e) {
                        LOG.warn("Unable to parse URL type on " + child.getName(), (Throwable)e);
                    }
                    continue;
                }
                if (type.equals("boolean")) {
                    tags.add(new CustomTagImpl(child.getName(), Boolean.valueOf(child.getTextTrim().toLowerCase())));
                    continue;
                }
                if (type.equals("location")) {
                    tags.add(new CustomTagImpl(child.getName(), new CustomTagImpl.Location(child.getText())));
                    continue;
                }
                throw new Exception("Unknown type: " + type);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse type on " + child.getName(), (Throwable)e);
            }
        }
        module.setValues(tags);
        return module;
    }

    public String getNamespaceUri() {
        return "http://base.google.com/cns/1.0";
    }
}

