/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports.converters;

import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.converters.LogConverter;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.utils.DateTimeUtil;
import com.relevantcodes.extentreports.utils.ExtentUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ChildTestConverter
extends LogSettings {
    private Element test;

    public List<Test> getNodeList() {
        Elements allNodes = this.test.select(".node-list > li");
        LinkedHashMap<Integer, Test> testLevelsMap = new LinkedHashMap<Integer, Test>();
        if (allNodes != null && allNodes.size() > 0) {
            ArrayList<Test> extentNodeList = new ArrayList<Test>();
            for (Element node : allNodes) {
                Test extentNode = new Test();
                extentNode.isChildNode = true;
                extentNode.setName(node.select(".test-node-name").first().html());
                Element description = node.select(".test-node-desc").first();
                if (description != null) {
                    extentNode.setDescription(description.html());
                }
                extentNode.setStatus(ExtentUtil.toLogStatus(node.select(".test-status").first().text()));
                extentNode.setStartedTime(DateTimeUtil.getDate(node.select(".test-started-time").first().text(), ChildTestConverter.getLogDateTimeFormat()));
                extentNode.setEndedTime(DateTimeUtil.getDate(node.select(".test-ended-time").first().text(), ChildTestConverter.getLogDateTimeFormat()));
                LogConverter logConverter = new LogConverter(node, true);
                List<Log> logList = logConverter.getLogList();
                extentNode.setLog(logList);
                Integer level = Integer.valueOf(node.attr("class").replaceAll("\\D+", ""));
                testLevelsMap.put(level, extentNode);
                if (level != 1) {
                    ((Test)testLevelsMap.get(level - 1)).setNode(extentNode);
                    continue;
                }
                extentNodeList.add(extentNode);
            }
            return extentNodeList;
        }
        return null;
    }

    public ChildTestConverter(Element test) {
        this.test = test;
    }
}

