/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.IReporter;
import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.NetworkMode;
import com.relevantcodes.extentreports.Report;
import com.relevantcodes.extentreports.SystemInfo;
import com.relevantcodes.extentreports.model.ExceptionInfo;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.utils.Resources;
import com.relevantcodes.extentreports.utils.Writer;
import com.relevantcodes.extentreports.view.Icon;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLReporter
extends LogSettings
implements IReporter {
    private static final Logger logger = Logger.getLogger(HTMLReporter.class.getName());
    private Report report;
    private Map<String, Object> templateMap;
    private String templateName = "Extent.ftl";
    private String filePath;
    private final String offlineFolderParent = "extentreports";

    @Override
    public void start(Report report) {
        this.report = report;
        if (this.templateMap != null) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.relevantcodes.extentreports.view.resources.localized", this.getDocumentLocale());
        this.templateMap = new HashMap<String, Object>();
        this.templateMap.put("report", this);
        this.templateMap.put("Icon", new Icon(report.getNetworkMode()));
        this.templateMap.put("resourceBundle", resourceBundle);
        BeansWrapperBuilder builder = new BeansWrapperBuilder(Configuration.VERSION_2_3_23);
        BeansWrapper beansWrapper = builder.build();
        try {
            TemplateHashModel fieldTypeModel = (TemplateHashModel)beansWrapper.getEnumModels().get(LogStatus.class.getName());
            this.templateMap.put("LogStatus", fieldTypeModel);
        }
        catch (TemplateModelException e) {
            e.printStackTrace();
        }
        File reportFile = new File(this.filePath);
        if (report.getNetworkMode() == NetworkMode.OFFLINE) {
            this.templateName = "Extent.Offline.ftl";
            this.initOfflineMode(reportFile);
        }
    }

    private void initOfflineMode(File file) {
        String[] folderNames;
        String s = "/";
        String resourcePackagePath = HTMLReporter.class.getPackage().getName().replace(".", s);
        resourcePackagePath = resourcePackagePath + s + "view" + s;
        String cssPath = resourcePackagePath + "offline" + s + "css" + s;
        String fontsPath = cssPath + "fonts" + s;
        String jsPath = resourcePackagePath + "offline" + s + "js" + s;
        String[] css = new String[]{"css.css"};
        String[] fonts = new String[]{"font-awesome.css.map", "fontawesome-webfont.eot", "fontawesome-webfont.svg", "fontawesome-webfont.ttf", "fontawesome-webfont.woff", "fontawesome-webfont.woff2", "FontAwesome.otf", "Roboto-Bold.eot", "Roboto-Bold.ttf", "Roboto-Bold.woff", "Roboto-Bold.woff2", "Roboto-Light.eot", "Roboto-Light.ttf", "Roboto-Light.woff", "Roboto-Light.woff2", "Roboto-Medium.eot", "Roboto-Medium.ttf", "Roboto-Medium.woff", "Roboto-Medium.woff2", "Roboto-Regular.eot", "Roboto-Regular.ttf", "Roboto-Regular.woff", "Roboto-Regular.woff2", "Roboto-Thin.eot", "Roboto-Thin.ttf", "Roboto-Thin.woff", "Roboto-Thin.woff2"};
        String[] js = new String[]{"scripts.js"};
        for (String name : folderNames = new String[]{"css" + s + "fonts", "js"}) {
            new File(file.getParent() + s + "extentreports" + s + name).mkdirs();
        }
        String destPath = file.getParent().replace("\\", s) + s + "extentreports" + s;
        for (String f : css) {
            Resources.moveResource(cssPath + f, destPath + "css" + s + f);
        }
        for (String f : fonts) {
            Resources.moveResource(fontsPath + f, destPath + "css" + s + "fonts" + s + f);
        }
        for (String f : js) {
            Writer.getInstance().write(new File(destPath + "js" + s + f), Resources.getText(jsPath + f));
        }
    }

    @Override
    public synchronized void flush() {
        String extentSource = null;
        try {
            Template template = this.getConfig().getTemplate(this.templateName);
            StringWriter out = new StringWriter();
            try {
                template.process(this.templateMap, (java.io.Writer)out);
                extentSource = out.toString().replace("\t", "");
            }
            catch (TemplateException e) {
                e.printStackTrace();
            }
            out.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Template not found", e);
        }
        Writer.getInstance().write(new File(this.filePath), extentSource);
    }

    private Configuration getConfig() {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
        cfg.setClassForTemplateLoading(HTMLReporter.class, "view");
        cfg.setDefaultEncoding("UTF-8");
        return cfg;
    }

    @Override
    public void stop() {
    }

    @Override
    public void setTestRunnerLogs() {
    }

    @Override
    public synchronized void addTest(Test test) {
    }

    public Map<String, String> getConfigurationMap() {
        return this.report.getConfigurationMap();
    }

    public Map<String, List<Test>> getCategoryTestMap() {
        return this.report.getCategoryTestMap();
    }

    public Map<String, List<ExceptionInfo>> getExceptionTestMap() {
        return this.report.getExceptionTestMap();
    }

    public SystemInfo getSystemInfo() {
        return this.report.getSystemInfo();
    }

    public Map<String, String> getSystemInfoMap() {
        return this.report.getSystemInfoMap();
    }

    public List<ExtentTest> getTestList() {
        return this.report.getTestList();
    }

    public Date getStartedTime() {
        return new Date(this.report.getSuiteTimeInfo().getSuiteStartTimestamp());
    }

    public String getRunDuration() {
        return this.report.getRunDuration();
    }

    public String getRunDurationOverall() {
        return this.report.getRunDurationOverall();
    }

    public List<String> getTestRunnerLogList() {
        return this.report.getTestRunnerLogList();
    }

    public List<LogStatus> getLogStatusList() {
        return this.report.getLogStatusList();
    }

    public String getMongoDBObjectID() {
        String id = this.report.getMongoDBObjectID();
        if (id == null) {
            id = "";
        }
        return id;
    }

    public UUID getReportId() {
        return this.report.getId();
    }

    public HTMLReporter(String filePath) {
        this.filePath = filePath;
    }

    private Locale getDocumentLocale() {
        return this.report.getDocumentLocale();
    }

    @Deprecated
    public class Config {
        @Deprecated
        public Config insertJs(String js) {
            return this;
        }

        @Deprecated
        public Config insertCustomStyles(String styles) {
            return this;
        }

        @Deprecated
        public Config addCustomStylesheet(String cssFilePath) {
            return this;
        }

        @Deprecated
        public Config reportHeadline(String headline) {
            return this;
        }

        @Deprecated
        public Config reportName(String name) {
            return this;
        }

        @Deprecated
        public Config documentTitle(String title) {
            return this;
        }
    }
}

