/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.types;

import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeArgument;
import com.rosetta.util.types.JavaTypeArgumentVisitor;
import com.rosetta.util.types.JavaTypeVariable;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JavaWildcardTypeArgument
implements JavaTypeArgument {
    private final boolean extendsBound;
    private final Optional<JavaReferenceType> bound;

    protected JavaWildcardTypeArgument() {
        this.extendsBound = false;
        this.bound = Optional.empty();
    }

    protected JavaWildcardTypeArgument(boolean extendsBound, JavaReferenceType bound) {
        Objects.requireNonNull(bound);
        this.extendsBound = extendsBound;
        this.bound = Optional.of(bound);
    }

    public static JavaWildcardTypeArgument from(WildcardType a, Map<TypeVariable<?>, JavaTypeVariable> context) {
        if (a.getUpperBounds().length > 0) {
            JavaType bound = JavaType.from(a.getUpperBounds()[0], context);
            if (bound instanceof JavaReferenceType) {
                return JavaWildcardTypeArgument.extendsBound((JavaReferenceType)bound);
            }
        } else if (a.getLowerBounds().length > 0) {
            JavaType bound = JavaType.from(a.getLowerBounds()[0], context);
            if (bound instanceof JavaReferenceType) {
                return JavaWildcardTypeArgument.superBound((JavaReferenceType)bound);
            }
        } else {
            return JavaWildcardTypeArgument.unbounded();
        }
        return null;
    }

    public static JavaWildcardTypeArgument unbounded() {
        return new JavaWildcardTypeArgument();
    }

    public static JavaWildcardTypeArgument extendsBound(JavaReferenceType bound) {
        return new JavaWildcardTypeArgument(true, bound);
    }

    public static JavaWildcardTypeArgument superBound(JavaReferenceType bound) {
        return new JavaWildcardTypeArgument(false, bound);
    }

    public boolean isUnbounded() {
        return !this.bound.isPresent();
    }

    public boolean hasExtendsBound() {
        return this.bound.isPresent() && this.extendsBound;
    }

    public boolean hasSuperBound() {
        return this.bound.isPresent() && !this.extendsBound;
    }

    public Optional<JavaReferenceType> getBound() {
        return this.bound;
    }

    public String toString() {
        StringBuilder target = new StringBuilder();
        target.append("?");
        if (this.hasExtendsBound()) {
            target.append(" extends ");
            target.append(this.bound.get());
        }
        if (this.hasSuperBound()) {
            target.append(" super ");
            target.append(this.bound.get());
        }
        return target.toString();
    }

    public int hashCode() {
        return Objects.hash(this.extendsBound, this.bound);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JavaWildcardTypeArgument other = (JavaWildcardTypeArgument)object;
        return this.extendsBound == other.extendsBound && Objects.equals(this.bound, other.bound);
    }

    @Override
    public void accept(JavaTypeArgumentVisitor visitor) {
        visitor.visitTypeArgument(this);
    }

    @Override
    public boolean contains(JavaTypeArgument other) {
        if (this.isUnbounded() || this.hasExtendsBound() && this.getBound().get().equals(JavaClass.OBJECT)) {
            return true;
        }
        JavaReferenceType bound = this.getBound().get();
        if (this.extendsBound) {
            if (other instanceof JavaReferenceType) {
                return ((JavaReferenceType)other).isSubtypeOf(bound);
            }
            JavaWildcardTypeArgument otherWildcard = (JavaWildcardTypeArgument)other;
            return otherWildcard.hasExtendsBound() && otherWildcard.getBound().get().isSubtypeOf(bound);
        }
        if (other instanceof JavaReferenceType) {
            return bound.isSubtypeOf((JavaReferenceType)other);
        }
        JavaWildcardTypeArgument otherWildcard = (JavaWildcardTypeArgument)other;
        return otherWildcard.hasSuperBound() && bound.isSubtypeOf(otherWildcard.getBound().get());
    }
}

