/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.path;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RosettaPath
implements Comparable<RosettaPath> {
    private final RosettaPath parent;
    private final Element element;

    private RosettaPath(RosettaPath parent, Element element) {
        this.parent = parent;
        this.element = element;
    }

    public static RosettaPath createPath(RosettaPath parent, Element element) {
        return new RosettaPath(parent, element);
    }

    public static RosettaPath createPath(Element element) {
        return new RosettaPath(null, element);
    }

    public static RosettaPath createPathFromElements(List<Element> elements) {
        RosettaPath newPath = null;
        for (Element element : elements) {
            if (newPath == null) {
                newPath = RosettaPath.createPath(Element.create(element.uri, element.path, element.index, element.attrs));
                continue;
            }
            newPath = newPath.newSubPath(element);
        }
        return newPath;
    }

    public static RosettaPath valueOf(String stringPath) {
        Iterable pathSections = Splitter.on((char)'.').split((CharSequence)stringPath);
        if (Iterables.size((Iterable)pathSections) == 0) {
            throw new IllegalArgumentException(stringPath + " is not a valid rosetta path");
        }
        RosettaPath path = RosettaPath.createPath(Element.valueOf((String)Iterables.getFirst((Iterable)pathSections, null)));
        for (String section : Iterables.skip((Iterable)pathSections, (int)1)) {
            path = path.newSubPath(Element.valueOf(section));
        }
        return path;
    }

    public RosettaPath newSubPath(Element element) {
        if (this.parent == null && element == null) {
            return new RosettaPath(null, null);
        }
        return new RosettaPath(this, element);
    }

    public RosettaPath newSubPath(String path, int index) {
        return this.newSubPath(Element.create(path, OptionalInt.of(index), null));
    }

    public RosettaPath newSubPath(String path) {
        return this.newSubPath(Element.create(path, OptionalInt.empty(), null));
    }

    public RosettaPath withIndex(int index) {
        Element el = this.getElement().withIndex(index);
        return new RosettaPath(this.parent, el);
    }

    public RosettaPath trimFirst() {
        LinkedList<Element> elements = this.allElements();
        elements.removeFirst();
        return RosettaPath.createPathFromElements(elements);
    }

    public LinkedList<Element> allElements() {
        LinkedList<Element> elements = new LinkedList<Element>();
        if (this.hasParent()) {
            elements.addAll(this.parent.allElements());
        }
        elements.add(this.element);
        return elements;
    }

    public List<String> allElementPaths() {
        return this.allElements().stream().map(Element::getPath).collect(Collectors.toList());
    }

    public String buildPath() {
        if (this.hasParent()) {
            return this.getParent().buildPath() + "." + this.element.asPathString();
        }
        return this.element.asPathString();
    }

    public RosettaPath getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this.element;
    }

    private boolean hasParent() {
        return !Objects.isNull(this.parent);
    }

    public boolean endsWith(RosettaPath other) {
        if (other == null) {
            return true;
        }
        if (!other.element.path.equals("*") && !other.element.path.equals(this.element.path)) {
            return false;
        }
        if (other.hasParent() && !this.hasParent()) {
            return false;
        }
        if (!this.hasParent() && !other.hasParent()) {
            return true;
        }
        return this.parent.endsWith(other.parent);
    }

    public boolean containsPath(RosettaPath subPath) {
        if (subPath == null) {
            return true;
        }
        if (subPath.element.path.equals(this.element.path) || subPath.element.path.equals("*")) {
            return this.parent.endsWith(subPath.parent);
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.containsPath(subPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RosettaPath that = (RosettaPath)o;
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return this.element != null ? this.element.equals(that.element) : that.element == null;
    }

    public boolean matchesIgnoringIndex(RosettaPath path) {
        if (!this.element.path.equals(path.element.path)) {
            return false;
        }
        if (this.parent == null) {
            return path.parent == null;
        }
        if (path.parent == null) {
            return false;
        }
        return this.parent.matchesIgnoringIndex(path.parent);
    }

    public RosettaPath toIndexless() {
        RosettaPath newParent = this.parent == null ? null : this.parent.toIndexless();
        Element newElement = new Element(this.element.getUri(), this.element.getPath(), OptionalInt.empty(), this.element.attrs);
        return new RosettaPath(newParent, newElement);
    }

    public String toString() {
        return this.buildPath();
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + (this.element != null ? this.element.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(RosettaPath other) {
        Iterator i1 = this.allElements().iterator();
        Iterator i2 = other.allElements().iterator();
        while (i1.hasNext() || i2.hasNext()) {
            if (!i1.hasNext()) {
                return -1;
            }
            if (!i2.hasNext()) {
                return 1;
            }
            int result = ((Element)i1.next()).compareTo((Element)i2.next());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public static class Element
    implements Comparable<Element> {
        public static final String DEFAULT_URI = "FpML_5_10";
        private final String uri;
        private final String path;
        private final OptionalInt index;
        private final Map<String, String> attrs;

        private Element(String uri, String path, OptionalInt index, Map<String, String> attrs) {
            this.uri = uri;
            this.path = path;
            this.index = index;
            this.attrs = attrs == null ? Collections.emptyMap() : attrs;
        }

        public static Element create(String path, Map<String, String> attrs) {
            return new Element(DEFAULT_URI, path, OptionalInt.empty(), attrs);
        }

        public static Element create(String path, OptionalInt index, Map<String, String> attrs) {
            return new Element(DEFAULT_URI, path, index, attrs);
        }

        public static Element create(String uri, String path, OptionalInt index, Map<String, String> attrs) {
            return new Element(uri, path, index, attrs);
        }

        public static Element valueOf(String element) {
            Pattern p = Pattern.compile("^(\\w+|\\*)(?:\\(([0-9]+)\\))?(?:\\[([\\w\\-]+)=([\\w\\-]+)])?$");
            Matcher matcher = p.matcher(element);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(element + " is not a valid path element");
            }
            OptionalInt index = matcher.group(2) == null ? OptionalInt.empty() : OptionalInt.of(Integer.parseInt(matcher.group(2)));
            String attrKey = matcher.group(3);
            String attrValue = matcher.group(4);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (attrKey != null && attrValue != null) {
                builder.put((Object)attrKey, (Object)attrValue);
            }
            return Element.create(matcher.group(1), index, (Map<String, String>)builder.build());
        }

        public Element withIndex(int newIndex) {
            return new Element(this.uri, this.path, OptionalInt.of(newIndex), this.attrs);
        }

        public String getUri() {
            return this.uri;
        }

        public String getPath() {
            return this.path;
        }

        public OptionalInt getIndex() {
            return this.index;
        }

        public Map<String, String> getMetas() {
            return this.attrs;
        }

        private String asPathString() {
            String idSection = !this.attrs.isEmpty() ? this.attrs.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",", "[", "]")) : "";
            String indexSection = this.index.isPresent() ? String.format("(%s)", this.index.getAsInt()) : "";
            return String.format("%s%s%s", this.path, indexSection, idSection);
        }

        public String toString() {
            return "Element{path='" + this.path + '\'' + ", index=" + this.index + ", uri='" + this.uri + '\'' + ", attrs=" + this.attrs + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element element = (Element)o;
            if (this.uri != null ? !this.uri.equals(element.uri) : element.uri != null) {
                return false;
            }
            if (this.path != null ? !this.path.equals(element.path) : element.path != null) {
                return false;
            }
            if (this.index != null ? this.index.orElse(0) != element.index.orElse(0) : element.index != null) {
                return false;
            }
            return this.attrs != null ? this.attrs.equals(element.attrs) : element.attrs == null;
        }

        public int hashCode() {
            int result = this.uri != null ? this.uri.hashCode() : 0;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.index != null ? Integer.hashCode(this.index.orElse(0)) : 0);
            result = 31 * result + (this.attrs != null ? this.attrs.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(Element other) {
            return Comparator.comparing(Element::getPath).thenComparing((e1, e2) -> Integer.compare(e1.getIndex().orElse(0), e2.getIndex().orElse(0))).compare(this, other);
        }
    }

    public static class RosettaPathTree {
        private final RosettaPathTree parent;
        private Object value;
        private final Map<Element, RosettaPathTree> children = new HashMap<Element, RosettaPathTree>();

        public RosettaPathTree(RosettaPathTree parent) {
            this.parent = parent;
        }

        public static RosettaPathTree treeify(Map<RosettaPath, Object> paths) {
            RosettaPathTree result = new RosettaPathTree(null);
            for (Map.Entry<RosettaPath, Object> path : paths.entrySet()) {
                RosettaPathTree pathTree = RosettaPathTree.addToTree(path.getKey(), result);
                pathTree.value = path.getValue();
            }
            return result;
        }

        private static RosettaPathTree addToTree(RosettaPath path, RosettaPathTree top) {
            if (!path.hasParent()) {
                return top.children.computeIfAbsent(path.element, e -> new RosettaPathTree(top));
            }
            RosettaPathTree parent = RosettaPathTree.addToTree(path.parent, top);
            return parent.children.computeIfAbsent(path.element, e -> new RosettaPathTree(parent));
        }

        public RosettaPathTree getParent() {
            return this.parent;
        }

        public Map<Element, RosettaPathTree> getChildren() {
            return this.children;
        }

        public Object getValue() {
            return this.value;
        }

        public Object matches(RosettaPath p) {
            RosettaPathTree match = this.match(p);
            return match == null ? null : match.value;
        }

        private RosettaPathTree match(RosettaPath p) {
            if (!p.hasParent()) {
                return this.children.get(p.element);
            }
            RosettaPathTree t = this.match(p.parent);
            if (t == null) {
                return null;
            }
            return t.children.get(p.element);
        }

        public List<RosettaPathTree> matches(RosettaPath p, Comparator<Element> comparator) {
            return this.match(p, comparator).collect(Collectors.toList());
        }

        private Stream<RosettaPathTree> match(RosettaPath p, Comparator<Element> comparator) {
            if (!p.hasParent()) {
                return this.children.entrySet().stream().filter(c -> comparator.compare(p.element, (Element)c.getKey()) == 0).map(e -> (RosettaPathTree)e.getValue());
            }
            Stream<RosettaPathTree> t = this.match(p.parent, comparator);
            return t.flatMap(q -> q.children.entrySet().stream()).filter(c -> comparator.compare(p.element, (Element)c.getKey()) == 0).map(e -> (RosettaPathTree)e.getValue());
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.parent != null) {
                result.append(this.parent.parentString(this));
                result.append(", ");
            }
            if (this.children != null && !this.children.isEmpty()) {
                result.append("[" + this.children.entrySet().stream().map(e -> ((Element)e.getKey()).asPathString() + "=" + ((RosettaPathTree)e.getValue()).toString()).collect(Collectors.joining(", ")) + "]");
            }
            if (this.value != null) {
                result.append("=");
                result.append(this.value);
            }
            return result.toString();
        }

        public String parentString(RosettaPathTree child) {
            StringBuilder result = new StringBuilder();
            if (this.parent != null) {
                result.append(this.parent.parentString(this));
                result.append(", ");
            }
            this.children.entrySet().stream().filter(e -> e.getValue() == child).forEach(e -> result.append(((Element)e.getKey()).asPathString()));
            return result.toString();
        }
    }

    public static class NullPath
    extends RosettaPath {
        public NullPath() {
            super(null, null);
        }

        @Override
        public RosettaPath newSubPath(String p) {
            return NullPath.createPath(Element.valueOf(p));
        }
    }
}

