/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.expression;

import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.CompareHelper;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;

class ExpressionCompareUtil {
    ExpressionCompareUtil() {
    }

    static <T extends Comparable<? super T>, X extends Comparable<? super X>, G> ComparisonResult evaluate(Mapper<T> m1, Mapper<X> m2, CardinalityOperator o, ExpressionOperators.CompareFunction<Mapper<T>, Mapper<X>> func) {
        return func.apply(m1, m2, o);
    }

    static <T extends Comparable<? super T>, X extends Comparable<? super X>> ComparisonResult greaterThan(Mapper<T> m1, Mapper<X> m2, CardinalityOperator o) {
        BinaryOperator op = o == CardinalityOperator.All ? (a, b) -> a.compareTo(b) > 0 ? a : b : (a, b) -> a.compareTo(b) < 0 ? a : b;
        return ExpressionCompareUtil.compare(m1, m2, o, op, (a, b) -> CompareHelper.compare(a, b) > 0, ">");
    }

    static <T extends Comparable<? super T>, X extends Comparable<? super X>> ComparisonResult greaterThanEquals(Mapper<T> m1, Mapper<X> m2, CardinalityOperator o) {
        BinaryOperator op = o == CardinalityOperator.All ? (a, b) -> a.compareTo(b) > 0 ? a : b : (a, b) -> a.compareTo(b) < 0 ? a : b;
        return ExpressionCompareUtil.compare(m1, m2, o, op, (a, b) -> CompareHelper.compare(a, b) >= 0, ">=");
    }

    static <T extends Comparable<? super T>, X extends Comparable<? super X>> ComparisonResult lessThan(Mapper<T> m1, Mapper<X> m2, CardinalityOperator o) {
        BinaryOperator op = o == CardinalityOperator.All ? (a, b) -> a.compareTo(b) < 0 ? a : b : (a, b) -> a.compareTo(b) > 0 ? a : b;
        return ExpressionCompareUtil.compare(m1, m2, o, op, (a, b) -> CompareHelper.compare(a, b) < 0, "<");
    }

    static <T extends Comparable<? super T>, X extends Comparable<? super X>> ComparisonResult lessThanEquals(Mapper<T> m1, Mapper<X> m2, CardinalityOperator o) {
        BinaryOperator op = o == CardinalityOperator.All ? (a, b) -> a.compareTo(b) < 0 ? a : b : (a, b) -> a.compareTo(b) > 0 ? a : b;
        return ExpressionCompareUtil.compare(m1, m2, o, op, (a, b) -> CompareHelper.compare(a, b) <= 0, "<=");
    }

    private static <T extends Comparable<? super T>, X extends Comparable<? super X>> ComparisonResult compare(Mapper<T> m1, Mapper<X> m2, CardinalityOperator o, BinaryOperator<X> reducer, BiPredicate<T, X> comparator, String comparatorString) {
        boolean result;
        if (m1 == null || m2 == null) {
            return ComparisonResult.failureEmptyOperand("Null operand: [" + m1 + "] " + comparatorString + " [" + m2 + "]");
        }
        if (m2.resultCount() == 0 || m1.resultCount() == 0) {
            return ComparisonResult.failureEmptyOperand("Null operand: [" + m1.getPaths() + " : " + m1.get() + "] " + comparatorString + " [" + m2.getPaths() + " : " + m2.get() + "]");
        }
        Optional compareValue = m2.getMulti().stream().reduce(reducer);
        boolean bl = result = o == CardinalityOperator.All ? m1.getMulti().stream().allMatch(a -> comparator.test(a, (Comparable)compareValue.get())) : m1.getMulti().stream().anyMatch(a -> comparator.test(a, (Comparable)compareValue.get()));
        if (result) {
            return ComparisonResult.success();
        }
        return ComparisonResult.failure("all elements of paths " + m1.getPaths() + " values " + m1.getMulti() + " are not " + comparatorString + " than all elements of paths " + m2.getPaths() + " values " + m2.getMulti());
    }
}

