/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.transform;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.Multimap;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.rosetta.common.transform.TestPackUtils;
import com.regnosys.testing.TestingExpectationUtil;
import com.regnosys.testing.reports.ObjectMapperGenerator;
import com.regnosys.testing.transform.TransformTestResult;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformExpectationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformExpectationUtil.class);
    private static final ObjectWriter CONFIG_WRITER = ObjectMapperGenerator.createWriterMapper().writerWithDefaultPrettyPrinter();

    public static void writeExpectations(Multimap<String, TransformTestResult> actualExpectation, Path testPackConfigPath) throws JsonProcessingException {
        if (!TestingExpectationUtil.WRITE_EXPECTATIONS) {
            LOGGER.info("WRITE_EXPECTATIONS is set to false, not updating expectations.");
            return;
        }
        for (Map.Entry entry : actualExpectation.asMap().entrySet()) {
            String testPackId = (String)entry.getKey();
            TestPackModel model = TransformExpectationUtil.getTestPackModel(testPackId, TransformExpectationUtil.class.getClassLoader(), testPackConfigPath);
            Collection transformTestResults = (Collection)entry.getValue();
            List sampleModelList = transformTestResults.stream().map(TransformTestResult::getSampleModel).sorted(Comparator.comparing(TestPackModel.SampleModel::getId)).collect(Collectors.toList());
            TestPackModel testPackModel = new TestPackModel(model.getId(), model.getPipelineId(), model.getName(), sampleModelList);
            String configFileContent = CONFIG_WRITER.writeValueAsString((Object)testPackModel);
            TestingExpectationUtil.TEST_WRITE_BASE_PATH.filter(x$0 -> Files.exists(x$0, new LinkOption[0])).ifPresent(writeBasePath -> {
                Path configFileWritePath = writeBasePath.resolve(testPackConfigPath).resolve(testPackModel.getId() + ".json");
                TestingExpectationUtil.writeFile(configFileWritePath, configFileContent, TestingExpectationUtil.CREATE_EXPECTATION_FILES);
                transformTestResults.stream().forEach(r -> TestingExpectationUtil.writeFile(writeBasePath.resolve(r.getSampleModel().getOutputPath()), r.getOutput(), TestingExpectationUtil.CREATE_EXPECTATION_FILES));
            });
        }
    }

    private static TestPackModel getTestPackModel(String testPackId, ClassLoader classLoader, Path resourcePath) {
        List testPackUrls = TestPackUtils.findPaths((Path)resourcePath, (ClassLoader)classLoader, (String)"test-pack-.*\\.json");
        ObjectMapper mapper = RosettaObjectMapper.getNewRosettaObjectMapper();
        return testPackUrls.stream().map(url -> (TestPackModel)TestPackUtils.readFile((URL)url, (ObjectMapper)mapper, TestPackModel.class)).filter(testPackModel -> testPackModel.getId() != null).filter(testPackModel -> testPackModel.getId().equals(testPackId)).findFirst().orElseThrow();
    }
}

