/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.schemeimport.fpml;

import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;

public class FpMLSchemeHelper {
    public URL getLatestSetOfSchemeUrl() {
        String schemaPath;
        try {
            schemaPath = this.getLatestSetOfSchemeFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ClassPathUtils.loadFromClasspath((String)schemaPath, (ClassLoader)this.getClass().getClassLoader()).map(UrlUtils::toUrl).findFirst().orElseThrow();
    }

    public String getLatestSetOfSchemeFile() throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Path baseFolder = (Path)ClassPathUtils.loadFromClasspath((String)"coding-schemes/fpml", (ClassLoader)classLoader).findFirst().orElseThrow();
        Assertions.assertNotNull((Object)baseFolder);
        HashMap versionNumberFileName = new HashMap();
        try (Stream<Path> walk = Files.walk(baseFolder, new FileVisitOption[0]);){
            walk.filter(this::isSetOfSchemeXmlFile).forEach(inFile -> {
                String fileName = inFile.getFileName().toString();
                String versionNumber = fileName.substring(15, fileName.indexOf(".")).replace("-", ".");
                versionNumberFileName.put(fileName, new BigDecimal(versionNumber));
            });
        }
        BigDecimal highestVersion = new BigDecimal(0);
        Object latestSetOfSchemesFile = "coding-schemes/fpml/set-of-schemes-2-2.xml";
        for (Map.Entry entry : versionNumberFileName.entrySet()) {
            BigDecimal value = (BigDecimal)entry.getValue();
            if (value.unscaledValue().compareTo(highestVersion.unscaledValue()) <= 0) continue;
            highestVersion = value;
            latestSetOfSchemesFile = "coding-schemes/fpml/" + (String)entry.getKey();
        }
        return latestSetOfSchemesFile;
    }

    private boolean isSetOfSchemeXmlFile(Path inFile) {
        return inFile.getFileName().toString().endsWith(".xml") && inFile.getFileName().toString().contains("set-of-schemes-");
    }
}

