/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.schemeimport;

import com.google.common.annotations.VisibleForTesting;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.CollectionUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.transgest.ModelLoader;
import com.regnosys.testing.schemeimport.RosettaResourceWriter;
import com.regnosys.testing.schemeimport.SchemeEnumReader;
import com.regnosys.testing.schemeimport.SchemeImporter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemeImporterTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemeImporterTestHelper.class);
    @Inject
    private SchemeImporter schemeImporter;
    @Inject
    private ModelLoader modelLoader;
    private static final Comparator<RosettaEnumValue> enumValueComparator = Comparator.comparing(RosettaNamed::getName).thenComparing(RosettaDefinable::getDefinition);

    public void checkEnumsAreValid(String rosettaPathRoot, String body, String codingScheme, SchemeEnumReader schemeEnumReader, boolean writeTestOutput, EnumComparison enumComparison) throws IOException {
        URL[] rosettaPaths = this.getRosettaPaths(rosettaPathRoot);
        List models = this.modelLoader.loadRosettaModels(rosettaPaths);
        List<RosettaEnumeration> rosettaEnumsFromModel = this.schemeImporter.getRosettaEnumsFromModel(models, body, codingScheme);
        if (writeTestOutput) {
            this.persistEnumValues(rosettaEnumsFromModel, schemeEnumReader, enumComparison);
        }
        this.validateEnumValues(rosettaEnumsFromModel, schemeEnumReader, enumComparison);
    }

    private void persistEnumValues(List<RosettaEnumeration> rosettaEnumsFromModel, SchemeEnumReader schemeEnumReader, EnumComparison enumComparison) throws IOException {
        Map<String, String> generatedFromScheme = null;
        switch (enumComparison) {
            case ExactMatch: {
                for (RosettaEnumeration rosettaEnumeration : rosettaEnumsFromModel) {
                    List<RosettaEnumValue> codingSchemeEnumValues = this.schemeImporter.getEnumValuesFromCodingScheme(rosettaEnumeration, schemeEnumReader);
                    this.overwriteEnums(rosettaEnumeration, codingSchemeEnumValues);
                }
                generatedFromScheme = this.schemeImporter.generateRosettaEnums(rosettaEnumsFromModel);
                break;
            }
            case AdditiveMatch: {
                for (RosettaEnumeration rosettaEnumeration : rosettaEnumsFromModel) {
                    List<RosettaEnumValue> codingSchemeEnumValues = this.schemeImporter.getEnumValuesFromCodingScheme(rosettaEnumeration, schemeEnumReader);
                    this.addNewEnums(rosettaEnumeration, codingSchemeEnumValues);
                }
                generatedFromScheme = this.schemeImporter.generateRosettaEnums(rosettaEnumsFromModel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown enum value " + enumComparison);
            }
        }
        Assert.assertNotNull(generatedFromScheme);
        this.writeTestOutput(generatedFromScheme);
    }

    @VisibleForTesting
    boolean compareEnumValues(List<RosettaEnumValue> modelEnumValues, List<RosettaEnumValue> codingSchemeEnumValues, EnumComparison enumComparison) {
        if (enumComparison == EnumComparison.ExactMatch) {
            return CollectionUtils.listMatch(codingSchemeEnumValues, modelEnumValues, (a, b) -> enumValueComparator.compare((RosettaEnumValue)a, (RosettaEnumValue)b) == 0);
        }
        if (enumComparison == EnumComparison.AdditiveMatch) {
            return CollectionUtils.collectionContains(codingSchemeEnumValues, modelEnumValues, (a, b) -> enumValueComparator.compare((RosettaEnumValue)a, (RosettaEnumValue)b) == 0);
        }
        return false;
    }

    protected URL[] getRosettaPaths(String rosettaPathRoot) {
        return (URL[])ClassPathUtils.findPathsFromClassPath(List.of(rosettaPathRoot), (String)".*\\.rosetta", Optional.empty(), (ClassLoader)SchemeImporter.class.getClassLoader()).stream().map(UrlUtils::toUrl).toArray(URL[]::new);
    }

    protected boolean filterNamespace(RosettaModel model, String namespaceIncludeRegex) {
        return Optional.ofNullable(namespaceIncludeRegex).map(regex -> model.getName().matches((String)regex)).orElse(true);
    }

    protected String getContents(URL[] rosettaPaths, String fileName) throws IOException {
        URL rosettaPath = Arrays.stream(rosettaPaths).filter(x -> this.getFileName(x.getFile()).equals(fileName)).findFirst().orElseThrow();
        String contents = new String(rosettaPath.openStream().readAllBytes(), StandardCharsets.UTF_8);
        return RosettaResourceWriter.rewriteProjectVersion(contents);
    }

    protected String getFileName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    protected void writeTestOutput(Map<String, String> rosettaExpected) throws IOException {
        Path basePath = Optional.ofNullable(System.getenv("TEST_WRITE_BASE_PATH")).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).orElseThrow();
        for (String fileName : rosettaExpected.keySet()) {
            Path outputPath = basePath.resolve(fileName);
            Files.writeString(outputPath, (CharSequence)rosettaExpected.get(fileName), StandardCharsets.UTF_8, new OpenOption[0]);
            LOGGER.info("Wrote test output to {}", (Object)outputPath.toAbsolutePath());
        }
    }

    private void validateEnumValues(List<RosettaEnumeration> rosettaEnumsFromModel, SchemeEnumReader schemeEnumReader, EnumComparison enumComparison) {
        for (RosettaEnumeration rosettaEnumeration : rosettaEnumsFromModel) {
            EList modelEnumValues = rosettaEnumeration.getEnumValues();
            List<RosettaEnumValue> codingSchemeEnumValues = this.schemeImporter.getEnumValuesFromCodingScheme(rosettaEnumeration, schemeEnumReader);
            Assert.assertTrue((String)("Enum values for " + rosettaEnumeration.getName() + " do not match "), (boolean)this.compareEnumValues((List<RosettaEnumValue>)modelEnumValues, codingSchemeEnumValues, enumComparison));
        }
    }

    private void overwriteEnums(RosettaEnumeration rosettaEnumeration, List<RosettaEnumValue> newEnumValues) {
        rosettaEnumeration.getEnumValues().clear();
        rosettaEnumeration.getEnumValues().addAll(newEnumValues);
    }

    private void addNewEnums(RosettaEnumeration rosettaEnumeration, List<RosettaEnumValue> newEnumValues) {
        List newEnumNamesList = newEnumValues.stream().map(n -> n.getName()).collect(Collectors.toList());
        List removedEnums = rosettaEnumeration.getEnumValues().stream().filter(e -> !newEnumNamesList.contains(e.getName())).collect(Collectors.toList());
        newEnumValues.addAll(removedEnums);
        rosettaEnumeration.getEnumValues().clear();
        rosettaEnumeration.getEnumValues().addAll(newEnumValues);
    }

    public static enum EnumComparison {
        ExactMatch,
        AdditiveMatch;

    }
}

