/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.regnosys.rosetta.common.transform.TransformType;
import com.regnosys.testing.pipeline.FunctionNameHelper;
import com.regnosys.testing.pipeline.PipelineNode;
import com.regnosys.testing.pipeline.PipelineTree;
import com.regnosys.testing.pipeline.PipelineTreeConfig;
import com.regnosys.testing.pipeline.PipelineTreeCreationException;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineTreeBuilder {
    private final Logger LOGGER = LoggerFactory.getLogger(PipelineTreeBuilder.class);
    private final FunctionNameHelper helper;

    @Inject
    public PipelineTreeBuilder(FunctionNameHelper helper) {
        this.helper = helper;
    }

    public PipelineTree createPipelineTree(PipelineTreeConfig pipelineTreeConfig) {
        try {
            List<PipelineTreeConfig.TransformFunction> starting = pipelineTreeConfig.getStarting();
            List<PipelineNode> nodeList = starting.stream().map(t -> this.downstreamPipelines(pipelineTreeConfig, new PipelineNode(this.helper, t.getTransformType()).withFunction(t.getFunction()))).flatMap(Collection::stream).sorted(Comparator.comparing(PipelineNode::getTransformType)).collect(Collectors.toList());
            return new PipelineTree(nodeList, pipelineTreeConfig);
        }
        catch (Exception ex) {
            throw new PipelineTreeCreationException("could not create pipeline tree", ex);
        }
    }

    private List<PipelineNode> downstreamPipelines(PipelineTreeConfig pipelineChainFunction, PipelineNode currentPipeline) {
        ArrayList<PipelineNode> pipelineNodes = new ArrayList<PipelineNode>();
        pipelineNodes.add(currentPipeline);
        TransformType downstreamTransformType = pipelineChainFunction.getDownstreamTransformType(currentPipeline.getFunction());
        if (downstreamTransformType == null) {
            return pipelineNodes;
        }
        List<PipelineNode> pipelines = this.createPipelineAndLinkUpstream(pipelineChainFunction, currentPipeline, downstreamTransformType);
        List downstreamPipelines = pipelines.stream().map(dp -> this.downstreamPipelines(pipelineChainFunction, (PipelineNode)dp)).flatMap(Collection::stream).collect(Collectors.toList());
        pipelineNodes.addAll(downstreamPipelines);
        return pipelineNodes;
    }

    private List<PipelineNode> createPipelineAndLinkUpstream(PipelineTreeConfig pipelineChainFunction, PipelineNode currentPipeline, TransformType transformType) {
        List<Class<? extends RosettaFunction>> downstreamFunctions = pipelineChainFunction.getDownstreamFunctions(currentPipeline.getFunction());
        return new PipelineNode(this.helper, transformType).linkWithUpstream(currentPipeline).withFunctions(downstreamFunctions);
    }
}

