/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing;

import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingExpectationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestingExpectationUtil.class);
    public static boolean WRITE_EXPECTATIONS = Optional.ofNullable(System.getenv("WRITE_EXPECTATIONS")).map(Boolean::parseBoolean).orElse(false);
    public static boolean CREATE_EXPECTATION_FILES = Optional.ofNullable(System.getenv("CREATE_EXPECTATION_FILES")).map(Boolean::parseBoolean).orElse(false);
    public static Optional<Path> TEST_WRITE_BASE_PATH = Optional.ofNullable(System.getenv("TEST_WRITE_BASE_PATH")).map(x$0 -> Paths.get(x$0, new String[0]));

    public static String readStringFromResources(Path resourcePath) {
        return Optional.ofNullable(ClassPathUtils.getResource((Path)resourcePath)).map(UrlUtils::toPath).map(TestingExpectationUtil::readString).orElse(null);
    }

    public static String readString(Path fullPath) {
        try {
            return Files.exists(fullPath, new LinkOption[0]) ? Files.readString(fullPath) : null;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read path {}", (Object)fullPath, (Object)e);
            return null;
        }
    }

    public static void assertJsonEquals(String expectedJson, String resultJson) {
        Assertions.assertEquals((Object)TestingExpectationUtil.normaliseLineEndings(expectedJson), (Object)TestingExpectationUtil.normaliseLineEndings(resultJson));
    }

    public static String normaliseLineEndings(String str) {
        return Optional.ofNullable(str).map(s -> s.replace("\r", "")).orElse(null);
    }

    public static void writeFile(Path writePath, String json, boolean create) {
        try {
            if (create) {
                Files.createDirectories(writePath.getParent(), new FileAttribute[0]);
            }
            if (create || Files.exists(writePath, new LinkOption[0])) {
                Files.write(writePath, json.getBytes(), new OpenOption[0]);
                LOGGER.info("Wrote output to {}", (Object)writePath);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to write output to {}", (Object)writePath, (Object)e);
        }
    }
}

