/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.xtext.xbase.testing.JavaSource;

public class GeneratedCode {
    private final Map<String, String> generated;

    public GeneratedCode(Map<String, String> generated) {
        this.generated = generated;
    }

    public Map<String, String> getGenerated() {
        return this.generated;
    }

    public Set<String> getGeneratedClassNames() {
        return this.generated.keySet();
    }

    public List<JavaSource> getJavaSource() {
        return this.generated.entrySet().stream().map(e -> new JavaSource(this.toJavaFile((String)e.getKey()), (String)e.getValue())).collect(Collectors.toList());
    }

    public void writeClasses(String directory) throws IOException {
        for (Map.Entry<String, String> entry : this.generated.entrySet()) {
            String className = entry.getKey();
            Path path = Paths.get("target/" + directory + "/java", this.toJavaFile(className));
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, entry.getValue().getBytes(), new OpenOption[0]);
        }
    }

    private String toJavaFile(String className) {
        return className.replace(".", File.separator) + ".java";
    }
}

