/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.helper;

import com.redmadrobot.inputmask.helper.CaretStringIterator;
import com.redmadrobot.inputmask.helper.Compiler;
import com.redmadrobot.inputmask.model.CaretString;
import com.redmadrobot.inputmask.model.Next;
import com.redmadrobot.inputmask.model.Notation;
import com.redmadrobot.inputmask.model.State;
import com.redmadrobot.inputmask.model.state.EOLState;
import com.redmadrobot.inputmask.model.state.FixedState;
import com.redmadrobot.inputmask.model.state.FreeState;
import com.redmadrobot.inputmask.model.state.OptionalValueState;
import com.redmadrobot.inputmask.model.state.ValueState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u000bJ\u0006\u0010\u0018\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/redmadrobot/inputmask/helper/Mask;", "", "format", "", "customNotations", "", "Lcom/redmadrobot/inputmask/model/Notation;", "(Ljava/lang/String;Ljava/util/List;)V", "initialState", "Lcom/redmadrobot/inputmask/model/State;", "acceptableTextLength", "", "acceptableValueLength", "appendPlaceholder", "state", "placeholder", "apply", "Lcom/redmadrobot/inputmask/helper/Mask$Result;", "text", "Lcom/redmadrobot/inputmask/model/CaretString;", "autocomplete", "", "noMandatoryCharactersLeftAfterState", "totalTextLength", "totalValueLength", "Factory", "Result", "inputmask_release"})
public final class Mask {
    private final State initialState;
    private final List<Notation> customNotations;
    private static final Map<String, Mask> cache;
    public static final Factory Factory;

    @NotNull
    public final Result apply(@NotNull CaretString text, boolean autocomplete) {
        Next next;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        CaretStringIterator iterator = new CaretStringIterator(text, 0, 2, null);
        int affinity = 0;
        String extractedValue = "";
        String modifiedString = "";
        int modifiedCaretPosition = text.getCaretPosition();
        State state = this.initialState;
        boolean beforeCaret = iterator.beforeCaret();
        Character character = iterator.next();
        while (character != null) {
            next = state.accept(character.charValue());
            if (next != null) {
                state = next.getState();
                StringBuilder stringBuilder = new StringBuilder().append(modifiedString);
                Object object = next.getInsert();
                if (object == null) {
                    object = "";
                }
                modifiedString = stringBuilder.append(object).toString();
                StringBuilder stringBuilder2 = new StringBuilder().append(extractedValue);
                Object object2 = next.getValue();
                if (object2 == null) {
                    object2 = "";
                }
                extractedValue = stringBuilder2.append(object2).toString();
                if (next.getPass()) {
                    beforeCaret = iterator.beforeCaret();
                    character = iterator.next();
                    ++affinity;
                    continue;
                }
                if (beforeCaret && next.getInsert() != null) {
                    ++modifiedCaretPosition;
                }
                --affinity;
                continue;
            }
            if (iterator.beforeCaret()) {
                --modifiedCaretPosition;
            }
            beforeCaret = iterator.beforeCaret();
            character = iterator.next();
            --affinity;
        }
        while (autocomplete && beforeCaret) {
            if (state.autocomplete() == null) {
                break;
            }
            state = next.getState();
            modifiedString = modifiedString + (next.getInsert() != null ? next.getInsert() : "");
            extractedValue = extractedValue + (next.getValue() != null ? next.getValue() : "");
            if (next.getInsert() == null) continue;
            ++modifiedCaretPosition;
        }
        return new Result(new CaretString(modifiedString, modifiedCaretPosition), extractedValue, affinity, this.noMandatoryCharactersLeftAfterState(state));
    }

    @NotNull
    public final String placeholder() {
        return this.appendPlaceholder(this.initialState, "");
    }

    public final int acceptableTextLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof FreeState) && !(state instanceof ValueState)) continue;
            ++length;
        }
        return length;
    }

    public final int totalTextLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof FreeState) && !(state instanceof ValueState) && !(state instanceof OptionalValueState)) continue;
            ++length;
        }
        return length;
    }

    public final int acceptableValueLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof ValueState)) continue;
            ++length;
        }
        return length;
    }

    public final int totalValueLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof ValueState) && !(state instanceof OptionalValueState)) continue;
            ++length;
        }
        return length;
    }

    private final String appendPlaceholder(State state, String placeholder) {
        if (state == null) {
            return placeholder;
        }
        if (state instanceof EOLState) {
            return placeholder;
        }
        if (state instanceof FixedState) {
            return this.appendPlaceholder(state.getChild(), placeholder + ((FixedState)state).getOwnCharacter());
        }
        if (state instanceof FreeState) {
            return this.appendPlaceholder(state.getChild(), placeholder + ((FreeState)state).getOwnCharacter());
        }
        if (state instanceof OptionalValueState) {
            String string;
            OptionalValueState.StateType stateType = ((OptionalValueState)state).getType();
            if (stateType instanceof OptionalValueState.StateType.AlphaNumeric) {
                string = this.appendPlaceholder(state.getChild(), placeholder + "-");
            } else if (stateType instanceof OptionalValueState.StateType.Literal) {
                string = this.appendPlaceholder(state.getChild(), placeholder + "a");
            } else if (stateType instanceof OptionalValueState.StateType.Numeric) {
                string = this.appendPlaceholder(state.getChild(), placeholder + "0");
            } else if (stateType instanceof OptionalValueState.StateType.Custom) {
                string = this.appendPlaceholder(state.getChild(), placeholder + ((OptionalValueState.StateType.Custom)((OptionalValueState)state).getType()).getCharacter());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }
        if (state instanceof ValueState) {
            String string;
            ValueState.StateType stateType = ((ValueState)state).getType();
            if (stateType instanceof ValueState.StateType.AlphaNumeric) {
                string = this.appendPlaceholder(state.getChild(), placeholder + "-");
            } else if (stateType instanceof ValueState.StateType.Literal) {
                string = this.appendPlaceholder(state.getChild(), placeholder + "a");
            } else if (stateType instanceof ValueState.StateType.Numeric) {
                string = this.appendPlaceholder(state.getChild(), placeholder + "0");
            } else if (stateType instanceof ValueState.StateType.Ellipsis) {
                string = placeholder;
            } else if (stateType instanceof ValueState.StateType.Custom) {
                string = this.appendPlaceholder(state.getChild(), placeholder + ((ValueState.StateType.Custom)((ValueState)state).getType()).getCharacter());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }
        return placeholder;
    }

    private final boolean noMandatoryCharactersLeftAfterState(State state) {
        boolean bl;
        if (state instanceof EOLState) {
            bl = true;
        } else {
            if (state instanceof ValueState) {
                return ((ValueState)state).isElliptical();
            }
            bl = state instanceof FixedState || state instanceof FreeState ? false : this.noMandatoryCharactersLeftAfterState(state.nextState());
        }
        return bl;
    }

    public Mask(@NotNull String format, @NotNull List<Notation> customNotations) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull(customNotations, (String)"customNotations");
        this.customNotations = customNotations;
        this.initialState = new Compiler(this.customNotations).compile(format);
    }

    static {
        Factory = new Factory(null);
        cache = new HashMap();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/redmadrobot/inputmask/helper/Mask$Result;", "", "formattedText", "Lcom/redmadrobot/inputmask/model/CaretString;", "extractedValue", "", "affinity", "", "complete", "", "(Lcom/redmadrobot/inputmask/model/CaretString;Ljava/lang/String;IZ)V", "getAffinity", "()I", "getComplete", "()Z", "getExtractedValue", "()Ljava/lang/String;", "getFormattedText", "()Lcom/redmadrobot/inputmask/model/CaretString;", "inputmask_release"})
    public static final class Result {
        @NotNull
        private final CaretString formattedText;
        @NotNull
        private final String extractedValue;
        private final int affinity;
        private final boolean complete;

        @NotNull
        public final CaretString getFormattedText() {
            return this.formattedText;
        }

        @NotNull
        public final String getExtractedValue() {
            return this.extractedValue;
        }

        public final int getAffinity() {
            return this.affinity;
        }

        public final boolean getComplete() {
            return this.complete;
        }

        public Result(@NotNull CaretString formattedText, @NotNull String extractedValue, int affinity, boolean complete) {
            Intrinsics.checkParameterIsNotNull((Object)formattedText, (String)"formattedText");
            Intrinsics.checkParameterIsNotNull((Object)extractedValue, (String)"extractedValue");
            this.formattedText = formattedText;
            this.extractedValue = extractedValue;
            this.affinity = affinity;
            this.complete = complete;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/redmadrobot/inputmask/helper/Mask$Factory;", "", "()V", "cache", "", "", "Lcom/redmadrobot/inputmask/helper/Mask;", "getCache", "()Ljava/util/Map;", "getOrCreate", "format", "customNotations", "", "Lcom/redmadrobot/inputmask/model/Notation;", "inputmask_release"})
    public static final class Factory {
        private final Map<String, Mask> getCache() {
            return cache;
        }

        @NotNull
        public final Mask getOrCreate(@NotNull String format, @NotNull List<Notation> customNotations) {
            Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
            Intrinsics.checkParameterIsNotNull(customNotations, (String)"customNotations");
            Mask cachedMask = this.getCache().get(format);
            if (cachedMask == null) {
                cachedMask = new Mask(format, customNotations);
                Map<String, Mask> map = this.getCache();
                Mask mask = cachedMask;
                map.put(format, mask);
            }
            return cachedMask;
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

