/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask;

import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import com.redmadrobot.inputmask.MaskedTextChangedListener;
import com.redmadrobot.inputmask.helper.Mask;
import com.redmadrobot.inputmask.model.CaretString;
import com.redmadrobot.inputmask.model.Notation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\tH\u0016J(\u0010!\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0017H\u0016J \u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006("}, d2={"Lcom/redmadrobot/inputmask/PolyMaskTextChangedListener;", "Lcom/redmadrobot/inputmask/MaskedTextChangedListener;", "format", "", "customNotations", "", "Lcom/redmadrobot/inputmask/model/Notation;", "affineFormats", "autocomplete", "", "field", "Landroid/widget/EditText;", "listener", "Landroid/text/TextWatcher;", "valueListener", "Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;ZLandroid/widget/EditText;Landroid/text/TextWatcher;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "getAffineFormats", "()Ljava/util/List;", "setAffineFormats", "(Ljava/util/List;)V", "getCustomNotations", "calculateAffinity", "", "mask", "Lcom/redmadrobot/inputmask/helper/Mask;", "text", "caretPosition", "onFocusChange", "", "view", "Landroid/view/View;", "hasFocus", "onTextChanged", "", "cursorPosition", "before", "count", "pickMask", "setText", "inputmask_release"})
public final class PolyMaskTextChangedListener
extends MaskedTextChangedListener {
    @NotNull
    private final List<Notation> customNotations;
    @NotNull
    private List<String> affineFormats;

    @Override
    public void setText(@NotNull String text) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Mask.Result result = this.pickMask(text, text.length(), this.getAutocomplete()).apply(new CaretString(text, text.length()), this.getAutocomplete());
            EditText editText = (EditText)this.getField().get();
            if (editText != null) {
                editText.setText((CharSequence)result.getFormattedText().getString());
            }
            EditText editText2 = (EditText)this.getField().get();
            if (editText2 != null) {
                editText2.setSelection(result.getFormattedText().getCaretPosition());
            }
            MaskedTextChangedListener.ValueListener valueListener = this.getValueListener();
            if (valueListener == null) break block2;
            valueListener.onTextChanged(result.getComplete(), result.getExtractedValue());
        }
    }

    @Override
    public void onTextChanged(@NotNull CharSequence text, int cursorPosition, int before, int count) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            boolean isDeletion = before > 0 && count == 0;
            Mask.Result result = this.pickMask(((Object)text).toString(), isDeletion ? cursorPosition : cursorPosition + count, this.getAutocomplete() && !isDeletion).apply(new CaretString(((Object)text).toString(), isDeletion ? cursorPosition : cursorPosition + count), this.getAutocomplete() && !isDeletion);
            this.setAfterText(result.getFormattedText().getString());
            this.setCaretPosition(isDeletion ? cursorPosition : result.getFormattedText().getCaretPosition());
            MaskedTextChangedListener.ValueListener valueListener = this.getValueListener();
            if (valueListener == null) break block0;
            valueListener.onTextChanged(result.getComplete(), result.getExtractedValue());
        }
    }

    @Override
    public void onFocusChange(@Nullable View view, boolean hasFocus) {
        block6: {
            String string;
            CharSequence charSequence;
            if (!this.getAutocomplete() || !hasFocus) break block6;
            EditText editText = (EditText)this.getField().get();
            Object object = editText != null ? editText.getText() : null;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if ((charSequence = (CharSequence)object).length() == 0) {
                string = "";
            } else {
                EditText editText2 = (EditText)this.getField().get();
                string = String.valueOf(editText2 != null ? editText2.getText() : null);
            }
            String text = string;
            Mask.Result result = this.pickMask(text, text.length(), this.getAutocomplete()).apply(new CaretString(text, text.length()), this.getAutocomplete());
            EditText editText3 = (EditText)this.getField().get();
            if (editText3 != null) {
                editText3.setText((CharSequence)result.getFormattedText().getString());
            }
            EditText editText4 = (EditText)this.getField().get();
            if (editText4 != null) {
                editText4.setSelection(result.getFormattedText().getCaretPosition());
            }
            MaskedTextChangedListener.ValueListener valueListener = this.getValueListener();
            if (valueListener != null) {
                valueListener.onTextChanged(result.getComplete(), result.getExtractedValue());
            }
        }
    }

    private final Mask pickMask(String text, int caretPosition, boolean autocomplete) {
        int primaryAffinity = this.calculateAffinity(this.getMask(), text, caretPosition, autocomplete);
        List masks = new ArrayList();
        for (String format : this.affineFormats) {
            Mask mask = Mask.Factory.getOrCreate(format, this.customNotations);
            int affinity = this.calculateAffinity(mask, text, caretPosition, autocomplete);
            masks.add(new Pair((Object)mask, (Object)affinity));
        }
        List $receiver$iv = masks;
        if ($receiver$iv.size() > 1) {
            Object object = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Pair item = (Pair)a;
                    Comparable comparable = Integer.valueOf(((Number)item.getSecond()).intValue());
                    item = (Pair)b;
                    Comparable comparable2 = comparable;
                    Integer n = ((Number)item.getSecond()).intValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            CollectionsKt.sortWith((List)object, (Comparator)comparator);
        }
        int insertIndex = -1;
        for (Object object : CollectionsKt.withIndex((Iterable)masks)) {
            int index = object.component1();
            Pair maskAffinity = (Pair)object.component2();
            if (primaryAffinity < ((Number)maskAffinity.getSecond()).intValue()) continue;
            insertIndex = index;
            break;
        }
        if (insertIndex >= 0) {
            masks.add(insertIndex, new Pair((Object)this.getMask(), (Object)primaryAffinity));
        } else {
            masks.add(new Pair((Object)this.getMask(), (Object)primaryAffinity));
        }
        return (Mask)((Pair)CollectionsKt.first((List)masks)).getFirst();
    }

    private final int calculateAffinity(Mask mask, String text, int caretPosition, boolean autocomplete) {
        return mask.apply(new CaretString(text, caretPosition), autocomplete).getAffinity();
    }

    @NotNull
    public final List<Notation> getCustomNotations() {
        return this.customNotations;
    }

    @NotNull
    public final List<String> getAffineFormats() {
        return this.affineFormats;
    }

    public final void setAffineFormats(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.affineFormats = list;
    }

    public PolyMaskTextChangedListener(@NotNull String format, @NotNull List<Notation> customNotations, @NotNull List<String> affineFormats, boolean autocomplete, @NotNull EditText field, @Nullable TextWatcher listener, @Nullable MaskedTextChangedListener.ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull(customNotations, (String)"customNotations");
        Intrinsics.checkParameterIsNotNull(affineFormats, (String)"affineFormats");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        super(format, customNotations, autocomplete, field, listener, valueListener);
        this.customNotations = customNotations;
        this.affineFormats = affineFormats;
    }

    public /* synthetic */ PolyMaskTextChangedListener(String string, List list, List list2, boolean bl, EditText editText, TextWatcher textWatcher, MaskedTextChangedListener.ValueListener valueListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            textWatcher = null;
        }
        if ((n & 0x40) != 0) {
            valueListener = null;
        }
        this(string, list, list2, bl, editText, textWatcher, valueListener);
    }
}

