/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.helper;

import com.redmadrobot.inputmask.helper.Compiler;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/redmadrobot/inputmask/helper/FormatSanitizer;", "", "()V", "checkOpenBraces", "", "string", "", "divideBlocksWithMixedCharacters", "", "blocks", "getFormatBlocks", "formatString", "sanitize", "sortFormatBlocks", "inputmask_release"})
public final class FormatSanitizer {
    @NotNull
    public final String sanitize(@NotNull String formatString) throws Compiler.FormatError {
        Intrinsics.checkParameterIsNotNull((Object)formatString, (String)"formatString");
        this.checkOpenBraces(formatString);
        List<String> blocks = this.divideBlocksWithMixedCharacters(this.getFormatBlocks(formatString));
        return CollectionsKt.joinToString$default((Iterable)this.sortFormatBlocks(blocks), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private final List<String> getFormatBlocks(String formatString) {
        List blocks = new ArrayList();
        String currentBlock = "";
        CharSequence charSequence = formatString;
        String string = charSequence;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        for (int i = 0; i < cArray2.length; ++i) {
            char c = cArray2[i];
            if ('[' == c || '{' == c) {
                charSequence = currentBlock;
                if (charSequence.length() > 0) {
                    blocks.add(currentBlock);
                }
                currentBlock = "";
            }
            currentBlock = currentBlock + c;
            if (']' != c && '}' != c) continue;
            blocks.add(currentBlock);
            currentBlock = "";
        }
        CharSequence charSequence2 = currentBlock;
        if (!(charSequence2.length() == 0)) {
            blocks.add(currentBlock);
        }
        return blocks;
    }

    private final List<String> divideBlocksWithMixedCharacters(List<String> blocks) {
        List resultingBlocks = new ArrayList();
        block0: for (String block : blocks) {
            if (StringsKt.startsWith$default((String)block, (String)"[", (boolean)false, (int)2, null)) {
                String blockBuffer = "";
                CharIterator charIterator = StringsKt.iterator((CharSequence)block);
                while (charIterator.hasNext()) {
                    char blockCharacter = charIterator.nextChar();
                    if (blockCharacter == '[') {
                        blockBuffer = blockBuffer + blockCharacter;
                        continue;
                    }
                    if (blockCharacter == ']') {
                        blockBuffer = blockBuffer + blockCharacter;
                        resultingBlocks.add(blockBuffer);
                        continue block0;
                    }
                    if ((blockCharacter == '0' || blockCharacter == '9') && (StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"A", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"a", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"-", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"_", (boolean)false, (int)2, null))) {
                        blockBuffer = blockBuffer + "]";
                        resultingBlocks.add(blockBuffer);
                        blockBuffer = "[" + blockCharacter;
                        continue;
                    }
                    if ((blockCharacter == 'A' || blockCharacter == 'a') && (StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"0", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"9", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"-", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"_", (boolean)false, (int)2, null))) {
                        blockBuffer = blockBuffer + "]";
                        resultingBlocks.add(blockBuffer);
                        blockBuffer = "[" + blockCharacter;
                        continue;
                    }
                    if ((blockCharacter == '-' || blockCharacter == '_') && (StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"0", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"9", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"A", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)blockBuffer, (CharSequence)"a", (boolean)false, (int)2, null))) {
                        blockBuffer = blockBuffer + "]";
                        resultingBlocks.add(blockBuffer);
                        blockBuffer = "[" + blockCharacter;
                        continue;
                    }
                    blockBuffer = blockBuffer + blockCharacter;
                }
                continue;
            }
            resultingBlocks.add(block);
        }
        return resultingBlocks;
    }

    private final List<String> sortFormatBlocks(List<String> blocks) {
        List sortedBlocks = new ArrayList();
        for (String block : blocks) {
            String sortedBlock;
            if (StringsKt.startsWith$default((String)block, (String)"[", (boolean)false, (int)2, null)) {
                char[] cArray;
                StringBuilder stringBuilder;
                String string;
                if (StringsKt.contains$default((CharSequence)block, (CharSequence)"0", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)block, (CharSequence)"9", (boolean)false, (int)2, null)) {
                    string = StringsKt.replace$default((String)StringsKt.replace$default((String)block, (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null);
                    stringBuilder = new StringBuilder().append("[");
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.toCharArray(), (String)"(this as java.lang.String).toCharArray()");
                    sortedBlock = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)ArraysKt.sorted((char[])cArray), (CharSequence)"", null, null, (int)0, null, null, (int)62, null)).append("]").toString();
                } else if (StringsKt.contains$default((CharSequence)block, (CharSequence)"a", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)block, (CharSequence)"A", (boolean)false, (int)2, null)) {
                    string = StringsKt.replace$default((String)StringsKt.replace$default((String)block, (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null);
                    stringBuilder = new StringBuilder().append("[");
                    String string3 = string;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.toCharArray(), (String)"(this as java.lang.String).toCharArray()");
                    sortedBlock = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)ArraysKt.sorted((char[])cArray), (CharSequence)"", null, null, (int)0, null, null, (int)62, null)).append("]").toString();
                } else {
                    string = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)block, (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null), (String)"_", (String)"A", (boolean)false, (int)4, null), (String)"-", (String)"a", (boolean)false, (int)4, null);
                    stringBuilder = new StringBuilder().append("[");
                    String string4 = string;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4.toCharArray(), (String)"(this as java.lang.String).toCharArray()");
                    sortedBlock = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)ArraysKt.sorted((char[])cArray), (CharSequence)"", null, null, (int)0, null, null, (int)62, null)).append("]").toString();
                    sortedBlock = StringsKt.replace$default((String)StringsKt.replace$default((String)sortedBlock, (String)"A", (String)"_", (boolean)false, (int)4, null), (String)"a", (String)"-", (boolean)false, (int)4, null);
                }
            } else {
                sortedBlock = block;
            }
            sortedBlocks.add(sortedBlock);
        }
        return sortedBlocks;
    }

    private final void checkOpenBraces(String string) {
        String string2;
        boolean squareBraceOpen = false;
        boolean curlyBraceOpen = false;
        String string3 = string2 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string3.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        for (int i = 0; i < cArray2.length; ++i) {
            char c = cArray2[i];
            if ('[' == c) {
                if (squareBraceOpen) {
                    throw (Throwable)new Compiler.FormatError();
                }
                squareBraceOpen = true;
            }
            if (']' == c) {
                squareBraceOpen = false;
            }
            if ('{' == c) {
                if (curlyBraceOpen) {
                    throw (Throwable)new Compiler.FormatError();
                }
                curlyBraceOpen = true;
            }
            if ('}' != c) continue;
            curlyBraceOpen = false;
        }
    }
}

