/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.helper;

import com.redmadrobot.inputmask.helper.FormatSanitizer;
import com.redmadrobot.inputmask.model.State;
import com.redmadrobot.inputmask.model.state.EOLState;
import com.redmadrobot.inputmask.model.state.FixedState;
import com.redmadrobot.inputmask.model.state.FreeState;
import com.redmadrobot.inputmask.model.state.OptionalValueState;
import com.redmadrobot.inputmask.model.state.ValueState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/redmadrobot/inputmask/helper/Compiler;", "", "()V", "compile", "Lcom/redmadrobot/inputmask/model/State;", "formatString", "", "valueable", "", "fixed", "FormatError", "inputmask_release"})
public final class Compiler {
    @NotNull
    public final State compile(@NotNull String formatString) throws FormatError {
        Intrinsics.checkParameterIsNotNull((Object)formatString, (String)"formatString");
        String sanitizedString = new FormatSanitizer().sanitize(formatString);
        return this.compile(sanitizedString, false, false);
    }

    private final State compile(String formatString, boolean valueable, boolean fixed) {
        if (0 >= formatString.length()) {
            return new EOLState();
        }
        char c = StringsKt.first((CharSequence)formatString);
        if ('[' == c) {
            return this.compile(StringsKt.drop((String)formatString, (int)1), true, false);
        }
        if ('{' == c) {
            return this.compile(StringsKt.drop((String)formatString, (int)1), false, true);
        }
        if (']' == c) {
            return this.compile(StringsKt.drop((String)formatString, (int)1), false, false);
        }
        if ('}' == c) {
            return this.compile(StringsKt.drop((String)formatString, (int)1), false, false);
        }
        if (valueable) {
            if ('0' == c) {
                return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false), ValueState.StateType.Numeric);
            }
            if ('A' == c) {
                return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false), ValueState.StateType.Literal);
            }
            if ('_' == c) {
                return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false), ValueState.StateType.AlphaNumeric);
            }
            if ('9' == c) {
                return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false), OptionalValueState.StateType.Numeric);
            }
            if ('a' == c) {
                return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false), OptionalValueState.StateType.Literal);
            }
            if ('-' == c) {
                return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false), OptionalValueState.StateType.AlphaNumeric);
            }
            throw (Throwable)new FormatError();
        }
        if (fixed) {
            return new FixedState(this.compile(StringsKt.drop((String)formatString, (int)1), false, true), c);
        }
        return new FreeState(this.compile(StringsKt.drop((String)formatString, (int)1), false, false), c);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/redmadrobot/inputmask/helper/Compiler$FormatError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "inputmask_release"})
    public static final class FormatError
    extends Exception {
    }
}

