/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask;

import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import com.redmadrobot.inputmask.MaskedTextChangedListener;
import com.redmadrobot.inputmask.helper.Mask;
import com.redmadrobot.inputmask.model.CaretString;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J(\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0016J \u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/redmadrobot/inputmask/PolyMaskTextChangedListener;", "Lcom/redmadrobot/inputmask/MaskedTextChangedListener;", "format", "", "affineFormats", "", "autocomplete", "", "field", "Landroid/widget/EditText;", "listener", "Landroid/text/TextWatcher;", "valueListener", "Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;", "(Ljava/lang/String;Ljava/util/List;ZLandroid/widget/EditText;Landroid/text/TextWatcher;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "getAffineFormats", "()Ljava/util/List;", "setAffineFormats", "(Ljava/util/List;)V", "calculateAffinity", "", "mask", "Lcom/redmadrobot/inputmask/helper/Mask;", "text", "caretPosition", "onFocusChange", "", "view", "Landroid/view/View;", "hasFocus", "onTextChanged", "", "cursorPosition", "before", "count", "pickMask", "setText", "inputmask-compileReleaseKotlin"})
public final class PolyMaskTextChangedListener
extends MaskedTextChangedListener {
    @NotNull
    private List<String> affineFormats;

    @NotNull
    public final List<String> getAffineFormats() {
        return this.affineFormats;
    }

    public final void setAffineFormats(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.affineFormats = list;
    }

    @Override
    public void setText(@NotNull String text) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Mask.Result result = this.pickMask(text, text.length(), this.getAutocomplete()).apply(new CaretString(text, text.length()), this.getAutocomplete());
            ((EditText)this.getField().get()).setText((CharSequence)result.getFormattedText().getString());
            ((EditText)this.getField().get()).setSelection(result.getFormattedText().getCaretPosition());
            MaskedTextChangedListener.ValueListener valueListener = this.getValueListener();
            if (valueListener == null) break block0;
            valueListener.onTextChanged(result.getExtractedValue().length() >= this.acceptableValueLength(), result.getExtractedValue());
        }
    }

    @Override
    public void onTextChanged(@NotNull CharSequence text, int cursorPosition, int before, int count) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            boolean isDeletion = before > 0;
            Mask.Result result = this.pickMask(((Object)text).toString(), isDeletion ? cursorPosition : cursorPosition + count, this.getAutocomplete() && !isDeletion).apply(new CaretString(((Object)text).toString(), isDeletion ? cursorPosition : cursorPosition + count), this.getAutocomplete() && !isDeletion);
            this.setAfterText(result.getFormattedText().getString());
            this.setCaretPosition(isDeletion ? cursorPosition : result.getFormattedText().getCaretPosition());
            MaskedTextChangedListener.ValueListener valueListener = this.getValueListener();
            if (valueListener == null) break block0;
            valueListener.onTextChanged(result.getExtractedValue().length() >= this.acceptableValueLength(), result.getExtractedValue());
        }
    }

    @Override
    public void onFocusChange(@Nullable View view, boolean hasFocus) {
        block1: {
            if (!this.getAutocomplete() || !hasFocus) break block1;
            CharSequence charSequence = (CharSequence)((EditText)this.getField().get()).getText();
            String text = charSequence.length() == 0 ? "" : ((EditText)this.getField().get()).getText().toString();
            Mask.Result result = this.pickMask(text, text.length(), this.getAutocomplete()).apply(new CaretString(text, text.length()), this.getAutocomplete());
            ((EditText)this.getField().get()).setText((CharSequence)result.getFormattedText().getString());
            ((EditText)this.getField().get()).setSelection(result.getFormattedText().getCaretPosition());
            MaskedTextChangedListener.ValueListener valueListener = this.getValueListener();
            if (valueListener != null) {
                valueListener.onTextChanged(result.getExtractedValue().length() >= this.acceptableValueLength(), result.getExtractedValue());
            }
        }
    }

    private final Mask pickMask(String text, int caretPosition, boolean autocomplete) {
        int n;
        int primaryAffinity = this.calculateAffinity(this.getMask(), text, caretPosition, autocomplete);
        List masks = new ArrayList();
        for (String string : this.affineFormats) {
            Mask mask = Mask.Factory.getOrCreate(string);
            int affinity = this.calculateAffinity(mask, text, caretPosition, autocomplete);
            masks.add(new Pair((Object)mask, (Object)affinity));
        }
        List list = masks;
        if (list.size() > 1) {
            Object indexedValue = list;
            Comparator comparator = new Comparator<Pair<? extends Mask, ? extends Integer>>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public int compare(Object a, Object b) {
                    Pair item = (Pair)a;
                    Comparable comparable = Integer.valueOf(((Number)item.getSecond()).intValue());
                    item = (Pair)b;
                    Comparable comparable2 = comparable;
                    Integer n = ((Number)item.getSecond()).intValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            CollectionsKt.sortWith((List)indexedValue, (Comparator)comparator);
        }
        int n2 = -1;
        for (Object indexedValue : CollectionsKt.withIndex((Iterable)masks)) {
            int index = indexedValue.component1();
            Pair maskAffinity = (Pair)indexedValue.component2();
            if (primaryAffinity < ((Number)maskAffinity.getSecond()).intValue()) continue;
            n = index;
            break;
        }
        if (n >= 0) {
            masks.add(n, new Pair((Object)this.getMask(), (Object)primaryAffinity));
        } else {
            masks.add(new Pair((Object)this.getMask(), (Object)primaryAffinity));
        }
        return (Mask)((Pair)CollectionsKt.first((List)masks)).getFirst();
    }

    private final int calculateAffinity(Mask mask, String text, int caretPosition, boolean autocomplete) {
        return mask.apply(new CaretString(text, caretPosition), autocomplete).getAffinity();
    }

    public PolyMaskTextChangedListener(@NotNull String format, @NotNull List<String> affineFormats, boolean autocomplete, @NotNull EditText field, @Nullable TextWatcher listener, @Nullable MaskedTextChangedListener.ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull(affineFormats, (String)"affineFormats");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        super(format, autocomplete, field, listener, valueListener);
        this.affineFormats = affineFormats;
    }
}

