/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.ByteCapacity;
import com.rabbitmq.stream.StreamCreator;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.impl.Client;
import com.rabbitmq.stream.impl.StreamEnvironment;
import com.rabbitmq.stream.impl.Utils;
import java.time.Duration;

class StreamStreamCreator
implements StreamCreator {
    private final StreamEnvironment environment;
    private final Client.StreamParametersBuilder streamParametersBuilder = new Client.StreamParametersBuilder().leaderLocator(StreamCreator.LeaderLocator.LEAST_LEADERS);
    private String stream;

    StreamStreamCreator(StreamEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public StreamCreator stream(String stream) {
        this.stream = stream;
        return this;
    }

    @Override
    public StreamCreator maxLengthBytes(ByteCapacity byteCapacity) {
        this.streamParametersBuilder.maxLengthBytes(byteCapacity);
        return this;
    }

    @Override
    public StreamCreator maxSegmentSizeBytes(ByteCapacity byteCapacity) {
        this.streamParametersBuilder.maxSegmentSizeBytes(byteCapacity);
        return this;
    }

    @Override
    public StreamCreator maxAge(Duration maxAge) {
        this.streamParametersBuilder.maxAge(maxAge);
        return this;
    }

    @Override
    public StreamCreator leaderLocator(StreamCreator.LeaderLocator leaderLocator) {
        this.streamParametersBuilder.leaderLocator(leaderLocator);
        return this;
    }

    @Override
    public void create() {
        if (this.stream == null) {
            throw new IllegalArgumentException("Stream cannot be null");
        }
        this.environment.maybeInitializeLocator();
        Client.Response response = this.environment.locator().create(this.stream, this.streamParametersBuilder.build());
        if (!response.isOk() && response.getResponseCode() != 5) {
            throw new StreamException("Error while creating stream '" + this.stream + "' (" + Utils.formatConstant(response.getResponseCode()) + ")", response.getResponseCode());
        }
    }
}

