/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.RoutingStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class RoutingKeyRoutingStrategy
implements RoutingStrategy {
    private final Function<Message, String> routingKeyExtractor;
    private final Map<String, List<String>> routingKeysToStreams = new ConcurrentHashMap<String, List<String>>();

    RoutingKeyRoutingStrategy(Function<Message, String> routingKeyExtractor) {
        this.routingKeyExtractor = routingKeyExtractor;
    }

    @Override
    public List<String> route(Message message, RoutingStrategy.Metadata metadata) {
        String routingKey = this.routingKeyExtractor.apply(message);
        List streams = this.routingKeysToStreams.computeIfAbsent(routingKey, routingKey1 -> metadata.route((String)routingKey1));
        return streams;
    }
}

