/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Codec;
import com.rabbitmq.stream.ConfirmationHandler;
import com.rabbitmq.stream.ConfirmationStatus;
import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.ObservationCollector;
import com.rabbitmq.stream.compression.CompressionCodec;
import com.rabbitmq.stream.impl.Client;
import com.rabbitmq.stream.impl.Clock;
import com.rabbitmq.stream.impl.DynamicBatchMessageAccumulator;
import com.rabbitmq.stream.impl.MessageAccumulator;
import com.rabbitmq.stream.impl.SimpleMessageAccumulator;
import com.rabbitmq.stream.impl.StreamProducer;
import com.rabbitmq.stream.impl.SubEntryMessageAccumulator;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToLongFunction;

final class ProducerUtils {
    private ProducerUtils() {
    }

    static MessageAccumulator createMessageAccumulator(boolean dynamicBatch, int subEntrySize, int batchSize, CompressionCodec compressionCodec, Codec codec, ByteBufAllocator byteBufAllocator, int maxFrameSize, ToLongFunction<Message> publishSequenceFunction, Function<Message, String> filterValueExtractor, Clock clock, String stream, ObservationCollector<?> observationCollector, StreamProducer producer) {
        if (dynamicBatch) {
            return new DynamicBatchMessageAccumulator(subEntrySize, batchSize, codec, maxFrameSize, publishSequenceFunction, filterValueExtractor, clock, stream, compressionCodec, byteBufAllocator, observationCollector, producer);
        }
        if (subEntrySize <= 1) {
            return new SimpleMessageAccumulator(batchSize, codec, maxFrameSize, publishSequenceFunction, filterValueExtractor, clock, stream, observationCollector, producer);
        }
        return new SubEntryMessageAccumulator(subEntrySize, batchSize, compressionCodec, codec, byteBufAllocator, maxFrameSize, publishSequenceFunction, clock, stream, observationCollector, producer);
    }

    static final class MessageAccumulatorHelper {
        private static final Function<Message, String> NULL_FILTER_VALUE_EXTRACTOR = m -> null;
        private final ObservationCollector<Object> observationCollector;
        private final ToLongFunction<Message> publishSequenceFunction;
        private final String stream;
        private final Codec codec;
        private final int maxFrameSize;
        private final Clock clock;
        private final Function<Message, String> filterValueExtractor;

        MessageAccumulatorHelper(Codec codec, int maxFrameSize, ToLongFunction<Message> publishSequenceFunction, Function<Message, String> filterValueExtractor, Clock clock, String stream, ObservationCollector<?> observationCollector) {
            this.publishSequenceFunction = publishSequenceFunction;
            this.codec = codec;
            this.clock = clock;
            this.maxFrameSize = maxFrameSize;
            this.filterValueExtractor = filterValueExtractor == null ? NULL_FILTER_VALUE_EXTRACTOR : filterValueExtractor;
            this.observationCollector = observationCollector;
            this.stream = stream;
        }

        AccumulatedEntity entity(Message message, ConfirmationHandler confirmationHandler) {
            Object observationContext = this.observationCollector.prePublish(this.stream, message);
            Codec.EncodedMessage encodedMessage = this.codec.encode(message);
            Client.checkMessageFitsInFrame(this.maxFrameSize, encodedMessage);
            long publishingId = this.publishSequenceFunction.applyAsLong(message);
            return new SimpleAccumulatedEntity(this.clock.time(), publishingId, this.filterValueExtractor.apply(message), this.codec.encode(message), new SimpleConfirmationCallback(message, confirmationHandler), observationContext);
        }

        Batch batch(ByteBufAllocator bba, byte compressionCode, CompressionCodec compressionCodec, int subEntrySize) {
            return new Batch(Client.EncodedMessageBatch.create(bba, compressionCode, compressionCodec, subEntrySize), new CompositeConfirmationCallback(new ArrayList<ConfirmationCallback>(subEntrySize)));
        }
    }

    static final class Batch
    implements AccumulatedEntity {
        final Client.EncodedMessageBatch encodedMessageBatch;
        private final CompositeConfirmationCallback confirmationCallback;
        volatile long publishingId;
        volatile long time;

        Batch(Client.EncodedMessageBatch encodedMessageBatch, CompositeConfirmationCallback confirmationCallback) {
            this.encodedMessageBatch = encodedMessageBatch;
            this.confirmationCallback = confirmationCallback;
        }

        void add(Codec.EncodedMessage encodedMessage, ConfirmationCallback confirmationCallback) {
            this.encodedMessageBatch.add(encodedMessage);
            this.confirmationCallback.add(confirmationCallback);
        }

        boolean isEmpty() {
            return this.confirmationCallback.callbacks.isEmpty();
        }

        @Override
        public long publishingId() {
            return this.publishingId;
        }

        @Override
        public String filterValue() {
            return null;
        }

        @Override
        public Object encodedEntity() {
            return this.encodedMessageBatch;
        }

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public ConfirmationCallback confirmationCallback() {
            return this.confirmationCallback;
        }

        @Override
        public Object observationContext() {
            throw new UnsupportedOperationException("batch entity does not contain only one observation context");
        }
    }

    static final class CompositeConfirmationCallback
    implements ConfirmationCallback {
        private final List<ConfirmationCallback> callbacks;

        CompositeConfirmationCallback(List<ConfirmationCallback> callbacks) {
            this.callbacks = callbacks;
        }

        private void add(ConfirmationCallback confirmationCallback) {
            this.callbacks.add(confirmationCallback);
        }

        @Override
        public int handle(boolean confirmed, short code) {
            for (ConfirmationCallback callback : this.callbacks) {
                callback.handle(confirmed, code);
            }
            return this.callbacks.size();
        }

        @Override
        public Message message() {
            throw new UnsupportedOperationException("composite confirmation callback does not contain just one message");
        }
    }

    static final class SimpleAccumulatedEntity
    implements AccumulatedEntity {
        private final long time;
        private final long publishingId;
        private final String filterValue;
        private final Codec.EncodedMessage encodedMessage;
        private final ConfirmationCallback confirmationCallback;
        private final Object observationContext;

        SimpleAccumulatedEntity(long time, long publishingId, String filterValue, Codec.EncodedMessage encodedMessage, ConfirmationCallback confirmationCallback, Object observationContext) {
            this.time = time;
            this.publishingId = publishingId;
            this.encodedMessage = encodedMessage;
            this.filterValue = filterValue;
            this.confirmationCallback = confirmationCallback;
            this.observationContext = observationContext;
        }

        @Override
        public long publishingId() {
            return this.publishingId;
        }

        @Override
        public String filterValue() {
            return this.filterValue;
        }

        @Override
        public Object encodedEntity() {
            return this.encodedMessage;
        }

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public ConfirmationCallback confirmationCallback() {
            return this.confirmationCallback;
        }

        @Override
        public Object observationContext() {
            return this.observationContext;
        }
    }

    static final class SimpleConfirmationCallback
    implements ConfirmationCallback {
        private final Message message;
        private final ConfirmationHandler confirmationHandler;

        SimpleConfirmationCallback(Message message, ConfirmationHandler confirmationHandler) {
            this.message = message;
            this.confirmationHandler = confirmationHandler;
        }

        @Override
        public int handle(boolean confirmed, short code) {
            this.confirmationHandler.handle(new ConfirmationStatus(this.message, confirmed, code));
            return 1;
        }

        @Override
        public Message message() {
            return this.message;
        }
    }

    static interface AccumulatedEntity {
        public long time();

        public long publishingId();

        public String filterValue();

        public Object encodedEntity();

        public ConfirmationCallback confirmationCallback();

        public Object observationContext();
    }

    static interface ConfirmationCallback {
        public int handle(boolean var1, short var2);

        public Message message();
    }
}

