/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.RoutingStrategy;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;

class HashRoutingStrategy
implements RoutingStrategy {
    private final Function<Message, String> routingKeyExtractor;
    private final ToIntFunction<String> hash;

    HashRoutingStrategy(Function<Message, String> routingKeyExtractor, ToIntFunction<String> hash) {
        this.routingKeyExtractor = routingKeyExtractor;
        this.hash = hash;
    }

    @Override
    public List<String> route(Message message, RoutingStrategy.Metadata metadata) {
        List<String> partitions = metadata.partitions();
        if (partitions.isEmpty()) {
            return Collections.emptyList();
        }
        String routingKey = this.routingKeyExtractor.apply(message);
        int hashValue = this.hash.applyAsInt(routingKey);
        return Collections.singletonList(partitions.get(Integer.remainderUnsigned(hashValue, partitions.size())));
    }
}

