/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingCell<T> {
    private boolean _filled = false;
    private T _value;

    public synchronized T get() throws InterruptedException {
        while (!this._filled) {
            this.wait();
        }
        return this._value;
    }

    public synchronized T uninterruptibleGet() {
        while (true) {
            try {
                return this.get();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized void set(T newValue) {
        if (this._filled) {
            throw new AssertionError((Object)"BlockingCell can only be set once");
        }
        this._value = newValue;
        this._filled = true;
        this.notify();
    }

    public synchronized boolean setIfUnset(T newValue) {
        if (this._filled) {
            return false;
        }
        this.set(newValue);
        this._filled = true;
        return true;
    }
}

